/*
 * Decompiled with CFR 0.152.
 */
package com.owlike.genson.ext.jsr353;

import com.owlike.genson.EncodingAwareReaderFactory;
import com.owlike.genson.ext.jsr353.GensonJsonGenerator;
import com.owlike.genson.ext.jsr353.GensonJsonParser;
import com.owlike.genson.ext.jsr353.JSR353Bundle;
import com.owlike.genson.stream.JsonReader;
import com.owlike.genson.stream.JsonWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import javax.json.JsonArray;
import javax.json.JsonException;
import javax.json.JsonObject;
import javax.json.JsonStructure;
import javax.json.stream.JsonParser;
import javax.json.stream.JsonParserFactory;

public class GensonJsonParserFactory
implements JsonParserFactory {
    private final boolean strictDoubleParse;
    private final EncodingAwareReaderFactory encodingAwareReaderFactory = new EncodingAwareReaderFactory();

    public GensonJsonParserFactory() {
        this.strictDoubleParse = false;
    }

    public GensonJsonParserFactory(Map<String, ?> config) {
        this.strictDoubleParse = JSR353Bundle.toBoolean(config, "GensonJsonParser.strictDoubleParse");
    }

    @Override
    public JsonParser createParser(Reader reader) {
        return new GensonJsonParser(new JsonReader(reader, this.strictDoubleParse, false));
    }

    @Override
    public JsonParser createParser(InputStream in) {
        try {
            return new GensonJsonParser(new JsonReader(this.encodingAwareReaderFactory.createReader(in), this.strictDoubleParse, false));
        }
        catch (IOException e) {
            throw new JsonException("Failed to detect encoding");
        }
    }

    @Override
    public JsonParser createParser(InputStream in, Charset charset) {
        return new GensonJsonParser(new JsonReader(new InputStreamReader(in, charset), this.strictDoubleParse, false));
    }

    @Override
    public JsonParser createParser(JsonObject obj) {
        return this.parserForJsonStructure(obj);
    }

    @Override
    public JsonParser createParser(JsonArray array) {
        return this.parserForJsonStructure(array);
    }

    private JsonParser parserForJsonStructure(JsonStructure jsonStructure) {
        StringWriter sw = new StringWriter();
        GensonJsonGenerator generator = new GensonJsonGenerator(new JsonWriter(sw));
        generator.write(jsonStructure);
        generator.flush();
        return this.createParser(new StringReader(sw.toString()));
    }

    @Override
    public Map<String, ?> getConfigInUse() {
        HashMap<String, Boolean> config = new HashMap<String, Boolean>();
        config.put("GensonJsonParser.strictDoubleParse", this.strictDoubleParse);
        return config;
    }
}

