/*
 * Decompiled with CFR 0.152.
 */
package com.owlike.genson.ext.jsr353;

import com.owlike.genson.ext.jsr353.GensonJsonGeneratorFactory;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.Map;
import javax.json.JsonArray;
import javax.json.JsonException;
import javax.json.JsonObject;
import javax.json.JsonStructure;
import javax.json.JsonWriter;
import javax.json.JsonWriterFactory;
import javax.json.stream.JsonGenerator;
import javax.json.stream.JsonGeneratorFactory;

public class GensonJsonWriterFactory
implements JsonWriterFactory {
    private final JsonGeneratorFactory generatorFactory;

    public GensonJsonWriterFactory() {
        this(Collections.emptyMap());
    }

    public GensonJsonWriterFactory(Map<String, ?> config) {
        this.generatorFactory = new GensonJsonGeneratorFactory(config);
    }

    @Override
    public JsonWriter createWriter(final Writer writer) {
        return new JsonWriter(){
            private final JsonGenerator generator;
            private boolean written;
            {
                this.generator = GensonJsonWriterFactory.this.generatorFactory.createGenerator(writer);
                this.written = false;
            }

            @Override
            public void writeArray(JsonArray array) {
                this.checkWritten();
                this.generator.write(array);
            }

            @Override
            public void writeObject(JsonObject object) {
                this.checkWritten();
                this.generator.write(object);
            }

            @Override
            public void write(JsonStructure value) {
                this.checkWritten();
                this.generator.write(value);
            }

            @Override
            public void close() {
                this.generator.close();
            }

            private void checkWritten() {
                if (this.written) {
                    throw new IllegalStateException();
                }
                this.written = true;
            }
        };
    }

    @Override
    public JsonWriter createWriter(OutputStream out) {
        try {
            return this.createWriter(new OutputStreamWriter(out, "UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new JsonException("Charset UTF-8 is not supported.", e);
        }
    }

    @Override
    public JsonWriter createWriter(OutputStream out, Charset charset) {
        return this.createWriter(new OutputStreamWriter(out, charset));
    }

    @Override
    public Map<String, ?> getConfigInUse() {
        return this.generatorFactory.getConfigInUse();
    }
}

