/*
 * Decompiled with CFR 0.152.
 */
package com.owlike.genson.ext.jsr353;

import com.owlike.genson.Context;
import com.owlike.genson.Converter;
import com.owlike.genson.Factory;
import com.owlike.genson.Genson;
import com.owlike.genson.GensonBuilder;
import com.owlike.genson.annotation.HandleClassMetadata;
import com.owlike.genson.ext.GensonBundle;
import com.owlike.genson.ext.jsr353.GensonJsonGenerator;
import com.owlike.genson.reflect.TypeUtil;
import com.owlike.genson.stream.JsonWriter;
import com.owlike.genson.stream.ObjectReader;
import com.owlike.genson.stream.ObjectWriter;
import com.owlike.genson.stream.ValueType;
import java.io.StringWriter;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import javax.json.JsonArray;
import javax.json.JsonArrayBuilder;
import javax.json.JsonBuilderFactory;
import javax.json.JsonNumber;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import javax.json.JsonString;
import javax.json.JsonValue;
import javax.json.spi.JsonProvider;

public class JSR353Bundle
extends GensonBundle {
    static final JsonBuilderFactory factory = JsonProvider.provider().createBuilderFactory(new HashMap());
    private boolean readUnknownTypesAsJsonValue = false;

    @Override
    public void configure(GensonBuilder builder) {
        if (this.readUnknownTypesAsJsonValue) {
            builder.withDeserializerFactory(new Factory<Converter<?>>(){

                @Override
                public Converter<?> create(Type type, Genson genson) {
                    if (Object.class.equals(TypeUtil.getRawClass(type))) {
                        return new JsonValueConverterWithClassMetadataForDeser();
                    }
                    return null;
                }
            });
        }
        builder.withConverterFactory(new Factory<Converter<JsonValue>>(){

            @Override
            public Converter<JsonValue> create(Type type, Genson genson) {
                return new JsonValueConverter();
            }
        });
    }

    public JSR353Bundle readUnknownTypesAsJsonValue(boolean enable) {
        this.readUnknownTypesAsJsonValue = true;
        return this;
    }

    static String toString(JsonValue value) {
        StringWriter sw = new StringWriter();
        JsonWriter writer = new JsonWriter(sw);
        GensonJsonGenerator generator = new GensonJsonGenerator(writer);
        generator.write(value);
        generator.close();
        return sw.toString();
    }

    static boolean toBoolean(Map<String, ?> config, String key) {
        if (config == null) {
            return false;
        }
        if (config.containsKey(key)) {
            Object value = config.get(key);
            if (value instanceof Boolean) {
                return (Boolean)value;
            }
            if (value instanceof String) {
                return Boolean.parseBoolean((String)value);
            }
            return false;
        }
        return false;
    }

    @HandleClassMetadata(serialization=true, deserialization=true)
    public class JsonValueConverter
    implements Converter<JsonValue> {
        @Override
        public void serialize(JsonValue value, ObjectWriter writer, Context ctx) {
            JsonValue.ValueType type = value.getValueType();
            if (JsonValue.ValueType.STRING == type) {
                writer.writeValue(((JsonString)value).getString());
            } else if (JsonValue.ValueType.ARRAY == type) {
                this.writeArray((JsonArray)value, writer, ctx);
            } else if (JsonValue.ValueType.OBJECT == type) {
                this.writeObject((JsonObject)value, writer, ctx);
            } else if (JsonValue.ValueType.NULL == type) {
                writer.writeNull();
            } else if (JsonValue.ValueType.NUMBER == type) {
                JsonNumber num = (JsonNumber)value;
                if (num.isIntegral()) {
                    writer.writeValue(num.longValue());
                } else {
                    writer.writeValue(num.bigDecimalValue());
                }
            } else if (JsonValue.ValueType.FALSE == type) {
                writer.writeValue(false);
            } else if (JsonValue.ValueType.TRUE == type) {
                writer.writeValue(true);
            } else {
                throw new IllegalStateException("Unknown ValueType " + (Object)((Object)type));
            }
        }

        private void writeArray(JsonArray array, ObjectWriter writer, Context ctx) {
            writer.beginArray();
            for (JsonValue value : array) {
                this.serialize(value, writer, ctx);
            }
            writer.endArray();
        }

        private void writeObject(JsonObject object, ObjectWriter writer, Context ctx) {
            writer.beginObject();
            for (Map.Entry e : object.entrySet()) {
                writer.writeName((String)e.getKey());
                this.serialize((JsonValue)e.getValue(), writer, ctx);
            }
            writer.endObject();
        }

        @Override
        public JsonValue deserialize(ObjectReader reader, Context ctx) {
            ValueType type = reader.getValueType();
            if (ValueType.OBJECT == type) {
                return this.deserObject(reader, ctx);
            }
            if (ValueType.ARRAY == type) {
                return this.deserArray(reader, ctx);
            }
            if (ValueType.STRING == type) {
                return (JsonValue)factory.createArrayBuilder().add(reader.valueAsString()).build().get(0);
            }
            if (ValueType.BOOLEAN == type) {
                return reader.valueAsBoolean() ? JsonValue.TRUE : JsonValue.FALSE;
            }
            if (ValueType.NULL == type) {
                return JsonValue.NULL;
            }
            if (ValueType.INTEGER == type) {
                return (JsonValue)factory.createArrayBuilder().add(reader.valueAsLong()).build().get(0);
            }
            if (ValueType.DOUBLE == type) {
                return (JsonValue)factory.createArrayBuilder().add(reader.valueAsDouble()).build().get(0);
            }
            throw new IllegalStateException("Unsupported ValueType " + (Object)((Object)type));
        }

        public JsonValue deserObject(ObjectReader reader, Context ctx) {
            JsonObjectBuilder builder = factory.createObjectBuilder();
            reader.beginObject();
            while (reader.hasNext()) {
                ValueType type = reader.next();
                String name = reader.name();
                if (ValueType.STRING == type) {
                    builder.add(name, reader.valueAsString());
                    continue;
                }
                if (ValueType.BOOLEAN == type) {
                    builder.add(name, reader.valueAsBoolean());
                    continue;
                }
                if (ValueType.NULL == type) {
                    builder.addNull(name);
                    continue;
                }
                if (ValueType.INTEGER == type) {
                    builder.add(name, reader.valueAsLong());
                    continue;
                }
                if (ValueType.DOUBLE == type) {
                    builder.add(name, reader.valueAsDouble());
                    continue;
                }
                builder.add(name, this.deserialize(reader, ctx));
            }
            reader.endObject();
            return builder.build();
        }

        public JsonValue deserArray(ObjectReader reader, Context ctx) {
            JsonArrayBuilder builder = factory.createArrayBuilder();
            reader.beginArray();
            while (reader.hasNext()) {
                ValueType type = reader.next();
                if (ValueType.STRING == type) {
                    builder.add(reader.valueAsString());
                    continue;
                }
                if (ValueType.BOOLEAN == type) {
                    builder.add(reader.valueAsBoolean());
                    continue;
                }
                if (ValueType.NULL == type) {
                    builder.addNull();
                    continue;
                }
                if (ValueType.INTEGER == type) {
                    builder.add(reader.valueAsLong());
                    continue;
                }
                if (ValueType.DOUBLE == type) {
                    builder.add(reader.valueAsDouble());
                    continue;
                }
                builder.add(this.deserialize(reader, ctx));
            }
            reader.endArray();
            return builder.build();
        }
    }

    @HandleClassMetadata(serialization=true, deserialization=false)
    private class JsonValueConverterWithClassMetadataForDeser
    extends JsonValueConverter {
        private JsonValueConverterWithClassMetadataForDeser() {
        }
    }
}

