/*
 * Decompiled with CFR 0.152.
 */
package io.takari.aether.localrepo;

import com.google.common.collect.Lists;
import io.takari.aether.localrepo.ArtifactValidator;
import io.takari.aether.localrepo.TakariLocalRepositoryManager;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.repository.LocalRepository;
import org.eclipse.aether.repository.LocalRepositoryManager;
import org.eclipse.aether.repository.NoLocalRepositoryManagerException;
import org.eclipse.aether.spi.localrepo.LocalRepositoryManagerFactory;

@Named(value="takari")
public class TakariLocalRepositoryManagerFactory
implements LocalRepositoryManagerFactory {
    @Inject
    List<ArtifactValidator> validators;

    @Override
    public LocalRepositoryManager newInstance(RepositorySystemSession session, LocalRepository repository) throws NoLocalRepositoryManagerException {
        if ("".equals(repository.getContentType()) || "default".equals(repository.getContentType())) {
            if (this.validators != null) {
                return new TakariLocalRepositoryManager(repository.getBasedir(), session, this.validators);
            }
            return new TakariLocalRepositoryManager(repository.getBasedir(), session, Lists.newArrayList());
        }
        throw new NoLocalRepositoryManagerException(repository);
    }

    @Override
    public float getPriority() {
        return 20.0f;
    }
}

