/*
 * Decompiled with CFR 0.152.
 */
package org.mule.maven.client.internal.concurrency;

import io.takari.filemanager.FileManager;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;
import org.eclipse.aether.spi.io.FileProcessor;
import org.eclipse.aether.spi.locator.Service;
import org.eclipse.aether.spi.locator.ServiceLocator;
import org.eclipse.aether.util.ChecksumUtils;

public class LockingFileProcessor
implements FileProcessor,
Service {
    private io.takari.aether.concurrency.LockingFileProcessor lockingFileProcessor;

    @Override
    public void initService(ServiceLocator locator) {
        FileManager fileManager = locator.getService(FileManager.class);
        Objects.requireNonNull(fileManager, String.format("%s has to be registered in ServiceLocator", FileManager.class.getName()));
        this.lockingFileProcessor = new io.takari.aether.concurrency.LockingFileProcessor(fileManager);
    }

    @Override
    public boolean mkdirs(File directory) {
        return this.lockingFileProcessor.mkdirs(directory);
    }

    @Override
    public void write(File target, String data) throws IOException {
        this.lockingFileProcessor.write(target, data);
    }

    @Override
    public void write(File target, InputStream source) throws IOException {
        this.lockingFileProcessor.write(target, source);
    }

    @Override
    public void move(File source, File target) throws IOException {
        this.lockingFileProcessor.move(source, target);
    }

    @Override
    public void copy(File source, File target) throws IOException {
        this.lockingFileProcessor.copy(source, target);
    }

    @Override
    public long copy(File source, File target, FileProcessor.ProgressListener listener) throws IOException {
        return this.lockingFileProcessor.copy(source, target, listener);
    }

    @Override
    public String readChecksum(File file) throws IOException {
        return ChecksumUtils.read(file);
    }

    @Override
    public void writeChecksum(File file, String s2) throws IOException {
        this.write(file, s2);
    }
}

