/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.plugins.coverage.core.interception;

import com.google.common.base.Preconditions;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.munit.plugins.coverage.core.LocationAccumulator;
import org.mule.munit.plugins.coverage.core.interception.ComponentLocationFilter;
import org.mule.munit.plugins.coverage.core.interception.CoverageProcessorInterceptor;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.interception.ProcessorInterceptor;
import org.mule.runtime.api.interception.ProcessorInterceptorFactory;

public class CoverageProcessorInterceptorFactory
implements ProcessorInterceptorFactory {
    public static final String MUNIT_COVERAGE_PROCESSOR_INTERCEPTOR_FACTORY_ID = "_munitCoverageProcessorInterceptorFactory";
    private transient Log logger = LogFactory.getLog(this.getClass());
    private LocationAccumulator locationAccumulator;

    public CoverageProcessorInterceptorFactory(LocationAccumulator locationAccumulator) {
        Preconditions.checkNotNull(locationAccumulator, "The reporter must not be null");
        this.locationAccumulator = locationAccumulator;
    }

    @Override
    public ProcessorInterceptor get() {
        return new CoverageProcessorInterceptor(this.locationAccumulator);
    }

    @Override
    public boolean intercept(ComponentLocation location) {
        this.logger.debug("Should coverage intercept: " + this.locationToStringLog(location));
        return ComponentLocationFilter.shouldIntercept(location);
    }

    private String locationToStringLog(ComponentLocation location) {
        return location.getComponentIdentifier().getIdentifier() + " in " + location.getFileName().orElse(" ? ") + "[line: " + location.getLineInFile().orElse(-1) + "].";
    }
}

