/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.plugins.coverage.core.model;

import com.google.common.collect.ImmutableList;
import java.io.Serializable;
import java.net.URI;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.stream.Collectors;
import org.mule.munit.plugins.coverage.core.model.CoverageComponentIdentifier;
import org.mule.munit.plugins.coverage.core.model.CoverageLocationPart;
import org.mule.munit.plugins.coverage.core.model.CoverageTypedComponentIdentifier;
import org.mule.runtime.api.component.TypedComponentIdentifier;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.component.location.LocationPart;
import org.mule.runtime.dsl.api.component.config.DefaultComponentLocation;

public class CoverageComponentLocation
implements ComponentLocation,
Serializable {
    private static final long serialVersionUID = 4958158607813720623L;
    private String name;
    private LinkedList<CoverageLocationPart> parts;
    private volatile String location;

    public static CoverageComponentLocation fromSingleComponent(String component) {
        CoverageTypedComponentIdentifier identifier = new CoverageTypedComponentIdentifier(CoverageComponentIdentifier.parseComponentIdentifier(component), TypedComponentIdentifier.ComponentType.UNKNOWN);
        CoverageLocationPart part = new CoverageLocationPart(component, Optional.of(identifier), Optional.empty(), Optional.empty());
        return new CoverageComponentLocation(Optional.of(component), Arrays.asList(part));
    }

    public CoverageComponentLocation(Optional<String> name, List<CoverageLocationPart> parts) {
        this.name = name.orElse(null);
        this.parts = new LinkedList<CoverageLocationPart>(parts);
    }

    public Optional<String> getName() {
        return Optional.ofNullable(this.name);
    }

    @Override
    public List<LocationPart> getParts() {
        return Collections.unmodifiableList(this.parts);
    }

    @Override
    public TypedComponentIdentifier getComponentIdentifier() {
        return this.parts.get(this.parts.size() - 1).getPartIdentifier().get();
    }

    @Override
    public Optional<String> getFileName() {
        return this.parts.getLast().getFileName();
    }

    @Override
    public List<URI> getImportChain() {
        return Collections.emptyList();
    }

    @Override
    public Optional<Integer> getLineInFile() {
        return this.parts.getLast().getLineInFile();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getLocation() {
        if (this.location == null) {
            CoverageComponentLocation coverageComponentLocation = this;
            synchronized (coverageComponentLocation) {
                if (this.location == null) {
                    StringBuilder locationBuilder = new StringBuilder();
                    for (CoverageLocationPart part : this.parts) {
                        locationBuilder.append("/").append(part.getPartPath());
                    }
                    this.location = locationBuilder.replace(0, 1, "").toString();
                }
            }
        }
        return this.location;
    }

    @Override
    public String getRootContainerName() {
        return ((LocationPart)this.getParts().stream().findFirst().get()).getPartPath();
    }

    public CoverageComponentLocation appendLocationPart(String partPath, Optional<TypedComponentIdentifier> partIdentifier, Optional<String> fileName, Optional<Integer> lineInFile) {
        return new CoverageComponentLocation(Optional.ofNullable(this.name), (List<CoverageLocationPart>)((Object)((ImmutableList.Builder)((ImmutableList.Builder)ImmutableList.builder().addAll(this.parts)).add(new CoverageLocationPart(partPath, CoverageTypedComponentIdentifier.fromTypedComponentIdentifier(partIdentifier), fileName, lineInFile))).build()));
    }

    public CoverageComponentLocation appendProcessorsPart() {
        return new CoverageComponentLocation(Optional.ofNullable(this.name), (List<CoverageLocationPart>)((Object)((ImmutableList.Builder)((ImmutableList.Builder)ImmutableList.builder().addAll(this.parts)).add(new CoverageLocationPart("processors", Optional.empty(), Optional.empty(), Optional.empty()))).build()));
    }

    public CoverageComponentLocation appendRoutePart() {
        return new CoverageComponentLocation(Optional.ofNullable(this.name), (List<CoverageLocationPart>)((Object)((ImmutableList.Builder)((ImmutableList.Builder)ImmutableList.builder().addAll(this.parts)).add(new CoverageLocationPart("route", Optional.empty(), Optional.empty(), Optional.empty()))).build()));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CoverageComponentLocation that = (CoverageComponentLocation)o;
        if (this.getName() != null ? !this.getName().equals(that.getName()) : that.getName() != null) {
            return false;
        }
        if (!this.getParts().equals(that.getParts())) {
            return false;
        }
        return this.getLocation() != null ? this.getLocation().equals(that.getLocation()) : that.getLocation() == null;
    }

    public int hashCode() {
        int result = this.getName() != null ? this.getName().hashCode() : 0;
        result = 31 * result + this.getParts().hashCode();
        result = 31 * result + (this.getLocation() != null ? this.getLocation().hashCode() : 0);
        return result;
    }

    public String toString() {
        return "DefaultComponentLocation{name='" + this.name + '\'' + ", parts=" + this.parts + ", location='" + this.getLocation() + '\'' + '}';
    }

    public static CoverageComponentLocation fromComponentLocation(ComponentLocation location) {
        Optional name = ((DefaultComponentLocation)location).getName();
        List<CoverageLocationPart> locationParts = location.getParts().stream().map(lp -> CoverageLocationPart.fromLocationPart(lp)).collect(Collectors.toList());
        return new CoverageComponentLocation(name, locationParts);
    }

    @Override
    public Optional<Integer> getStartColumn() {
        return Optional.empty();
    }

    @Override
    public OptionalInt getLine() {
        return OptionalInt.empty();
    }

    @Override
    public OptionalInt getColumn() {
        return OptionalInt.empty();
    }
}

