/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.remote.api.configuration;

import com.owlike.genson.Operations;
import java.util.Map;
import org.mule.munit.remote.api.configuration.ContainerConfiguration;
import org.mule.munit.remote.api.configuration.DeploymentConfiguration;
import org.mule.munit.remote.api.configuration.DeploymentType;
import org.mule.runtime.api.deployment.meta.Product;
import org.mule.tools.model.Deployment;

public class CloudHubContainerConfiguration
extends ContainerConfiguration {
    private DeploymentConfiguration deploymentConfiguration;
    private boolean debugEnabled;
    private String executionId;

    protected CloudHubContainerConfiguration(String runtimeId, String product, String munitWorkingDirectoryPath, String log4JConfigurationFilePath, DeploymentConfiguration deploymentConfiguration, boolean debugEnabled, String executionId, Map<String, String> systemPropertyVariables, Map<String, String> environmentVariables) {
        super(DeploymentType.CLOUDHUB.name(), runtimeId, product, munitWorkingDirectoryPath, log4JConfigurationFilePath, systemPropertyVariables, environmentVariables);
        this.deploymentConfiguration = deploymentConfiguration;
        this.debugEnabled = debugEnabled;
        this.executionId = executionId;
    }

    public DeploymentConfiguration getDeploymentConfiguration() {
        return this.deploymentConfiguration;
    }

    public boolean isDebugEnabled() {
        return this.debugEnabled;
    }

    @Override
    public DeploymentType getType() {
        return DeploymentType.CLOUDHUB;
    }

    public String getExecutionId() {
        return this.executionId;
    }

    public static class CloudHubContainerConfigurationBuilder
    implements ContainerConfiguration.ContainerConfigurationBuilder {
        private String runtimeId;
        private String product;
        private String munitWorkingDirectoryPath;
        private String log4JConfigurationFilePath;
        private DeploymentConfiguration deploymentConfiguration;
        private boolean debugEnabled;
        private String executionId;
        private Map<String, String> systemPropertyVariables;
        private Map<String, String> environmentVariables;

        public static CloudHubContainerConfigurationBuilder from(CloudHubContainerConfiguration cc) {
            CloudHubContainerConfigurationBuilder builder = new CloudHubContainerConfigurationBuilder();
            builder.withLog4JConfigurationFilePath(cc.getLog4JConfigurationFilePath());
            builder.withMunitWorkingDirectoryPath(cc.getMunitWorkingDirectoryPath());
            builder.withDeploymentConfiguration(cc.getDeploymentConfiguration().getDeployment());
            builder.withDebugEnabled(cc.isDebugEnabled());
            return builder;
        }

        public CloudHubContainerConfigurationBuilder withMunitWorkingDirectoryPath(String munitWorkingDirectoryPath) {
            this.munitWorkingDirectoryPath = munitWorkingDirectoryPath;
            return this;
        }

        public CloudHubContainerConfigurationBuilder withLog4JConfigurationFilePath(String log4JConfigurationFilePath) {
            this.log4JConfigurationFilePath = log4JConfigurationFilePath;
            return this;
        }

        public CloudHubContainerConfigurationBuilder withDebugEnabled(boolean debugEnabled) {
            this.debugEnabled = debugEnabled;
            return this;
        }

        public CloudHubContainerConfigurationBuilder withDeploymentConfiguration(Deployment deployment) {
            Operations.checkNotNull(deployment, "must not be null");
            this.runtimeId = deployment.getMuleVersion().orElseThrow(() -> new IllegalArgumentException("Deployment has no mule version"));
            this.product = Product.MULE_EE.name();
            this.deploymentConfiguration = new DeploymentConfiguration(DeploymentType.fromDeployment(deployment), deployment);
            return this;
        }

        public CloudHubContainerConfigurationBuilder withExecutionId(String executionId) {
            this.executionId = executionId;
            return this;
        }

        public CloudHubContainerConfigurationBuilder withSystemPropertyVariables(Map<String, String> systemPropertyVariables) {
            this.systemPropertyVariables = systemPropertyVariables;
            return this;
        }

        public CloudHubContainerConfigurationBuilder withEnvironmentVariables(Map<String, String> environmentVariables) {
            this.environmentVariables = environmentVariables;
            return this;
        }

        @Override
        public CloudHubContainerConfiguration build() {
            return new CloudHubContainerConfiguration(this.runtimeId, this.product, this.munitWorkingDirectoryPath, this.log4JConfigurationFilePath, this.deploymentConfiguration, this.debugEnabled, this.executionId, this.systemPropertyVariables, this.environmentVariables);
        }
    }
}

