/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.api.deployment.meta;

import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.mule.api.annotation.NoExtend;
import org.mule.runtime.api.util.Preconditions;

@NoExtend
public class MuleServiceContractModel {
    private final String serviceProviderClassName;
    private final String contractClassName;

    public MuleServiceContractModel(String serviceProviderClassName, String contractClassName) {
        Preconditions.checkArgument(!StringUtils.isBlank(serviceProviderClassName), "serviceProviderClassName cannot be blank");
        Preconditions.checkArgument(!StringUtils.isBlank(contractClassName), "satisfiedServiceClassName cannot be blank");
        this.serviceProviderClassName = serviceProviderClassName;
        this.contractClassName = contractClassName;
    }

    public String getServiceProviderClassName() {
        return this.serviceProviderClassName;
    }

    public String getContractClassName() {
        return this.contractClassName;
    }

    public boolean equals(Object obj) {
        if (obj instanceof MuleServiceContractModel) {
            MuleServiceContractModel other = (MuleServiceContractModel)obj;
            return Objects.equals(this.serviceProviderClassName, other.getServiceProviderClassName()) && Objects.equals(this.contractClassName, other.getContractClassName());
        }
        return false;
    }

    public int hashCode() {
        return this.serviceProviderClassName.hashCode() * this.contractClassName.hashCode() * 11;
    }
}

