/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.api.classloader;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.Type;
import org.mule.tools.api.classloader.AppClassLoaderModelJsonSerializer;
import org.mule.tools.api.classloader.ArtifactCustomJsonSerializer;
import org.mule.tools.api.classloader.model.AppClassLoaderModel;
import org.mule.tools.api.classloader.model.Artifact;
import org.mule.tools.api.classloader.model.ArtifactCoordinates;
import org.mule.tools.api.classloader.model.ClassLoaderModel;

public class ClassLoaderModelJsonSerializer {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static ClassLoaderModel deserialize(File classLoaderModelDescriptor) {
        try (BufferedReader reader = new BufferedReader(new FileReader(classLoaderModelDescriptor));){
            Gson gson = new GsonBuilder().enableComplexMapKeySerialization().create();
            ClassLoaderModel classLoaderModel = gson.fromJson((Reader)reader, ClassLoaderModel.class);
            ClassLoaderModelJsonSerializer.validate(classLoaderModel, classLoaderModelDescriptor);
            ClassLoaderModel classLoaderModel2 = classLoaderModel;
            return classLoaderModel2;
        }
        catch (IOException e) {
            throw new RuntimeException("Could not create classloader-model.json", e);
        }
    }

    protected static void validate(ClassLoaderModel classLoaderModel, File classLoaderModelDescriptor) {
        if (classLoaderModel.getVersion() == null) {
            throw new IllegalStateException(String.format("Error deserializing '%s'. \"version\" not specified.", classLoaderModelDescriptor.getName()));
        }
        ClassLoaderModelJsonSerializer.validateRootArtifactCoordinates(classLoaderModelDescriptor, classLoaderModel.getArtifactCoordinates());
        classLoaderModel.getDependencies().forEach(dep -> {
            ClassLoaderModelJsonSerializer.validateArtifactCoordinates(classLoaderModelDescriptor, dep.getArtifactCoordinates());
            if (dep.getUri() == null) {
                throw new IllegalStateException(String.format("Error deserializing '%s'. \"uri\" not specified for dependency '%s'", classLoaderModelDescriptor.getName(), dep.getArtifactCoordinates().getGroupId() + ":" + dep.getArtifactCoordinates().getArtifactId()));
            }
        });
    }

    private static void validateRootArtifactCoordinates(File classLoaderModelDescriptor, ArtifactCoordinates artifactCoordinates) {
        ClassLoaderModelJsonSerializer.validateArtifactCoordinates(classLoaderModelDescriptor, artifactCoordinates);
        if (artifactCoordinates.getClassifier() == null) {
            throw new IllegalStateException(String.format("Error deserializing '%s'. \"classifier\" not specified for '%s'.", classLoaderModelDescriptor.getName(), artifactCoordinates.getGroupId() + ":" + artifactCoordinates.getArtifactId()));
        }
    }

    private static void validateArtifactCoordinates(File classLoaderModelDescriptor, ArtifactCoordinates artifactCoordinates) {
        if (artifactCoordinates == null) {
            throw new IllegalStateException(String.format("Error deserializing '%s'. \"artifactCoordinates\" not specified.", classLoaderModelDescriptor.getName()));
        }
        if (artifactCoordinates.getGroupId() == null) {
            throw new IllegalStateException(String.format("Error deserializing '%s'. \"groupId\" not specified.", classLoaderModelDescriptor.getName()));
        }
        if (artifactCoordinates.getArtifactId() == null) {
            throw new IllegalStateException(String.format("Error deserializing '%s'. \"artifactId\" not specified.", classLoaderModelDescriptor.getName()));
        }
        if (artifactCoordinates.getVersion() == null) {
            throw new IllegalStateException(String.format("Error deserializing '%s'. \"version\" not specified for '%s'.", classLoaderModelDescriptor.getName(), artifactCoordinates.getGroupId() + ":" + artifactCoordinates.getArtifactId()));
        }
        if (artifactCoordinates.getType() == null) {
            throw new IllegalStateException(String.format("Error deserializing '%s'. \"type\" not specified for '%s'.", classLoaderModelDescriptor.getName(), artifactCoordinates.getGroupId() + ":" + artifactCoordinates.getArtifactId()));
        }
    }

    @Deprecated
    public static String serialize(ClassLoaderModel classLoaderModel) {
        return ClassLoaderModelJsonSerializer.serialize(classLoaderModel, true);
    }

    public static String serialize(ClassLoaderModel classLoaderModel, boolean prettyPrinting) {
        GsonBuilder gsonBuilder = new GsonBuilder().enableComplexMapKeySerialization();
        if (prettyPrinting) {
            gsonBuilder = gsonBuilder.setPrettyPrinting();
        }
        Gson gson = gsonBuilder.registerTypeAdapter((Type)((Object)Artifact.class), new ArtifactCustomJsonSerializer()).registerTypeAdapter((Type)((Object)AppClassLoaderModel.class), new AppClassLoaderModelJsonSerializer.AppClassLoaderModelCustomJsonSerializer()).registerTypeAdapter((Type)((Object)ClassLoaderModel.class), new ClassLoaderModelCustomJsonSerializer()).create();
        ClassLoaderModel parameterizedClassloaderModel = classLoaderModel.getParametrizedUriModel();
        return gson.toJson(parameterizedClassloaderModel);
    }

    public static File serializeToFile(ClassLoaderModel classLoaderModel, File destinationFolder) {
        return ClassLoaderModelJsonSerializer.serializeToFile(classLoaderModel, destinationFolder, true);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static File serializeToFile(ClassLoaderModel classLoaderModel, File destinationFolder, boolean prettyPrinting) {
        File destinationFile = new File(destinationFolder, "classloader-model.json");
        try {
            if (!destinationFolder.exists()) {
                destinationFolder.mkdirs();
            }
            destinationFile.createNewFile();
        }
        catch (IOException e) {
            throw new RuntimeException("Could not create classloader-model.json", e);
        }
        try (FileWriter writer = new FileWriter(destinationFile.getAbsolutePath());){
            writer.write(ClassLoaderModelJsonSerializer.serialize(classLoaderModel, prettyPrinting));
            ((Writer)writer).close();
            File file = destinationFile;
            return file;
        }
        catch (IOException e) {
            throw new RuntimeException("Could not create classloader-model.json", e);
        }
    }

    private static class ClassLoaderModelCustomJsonSerializer
    implements JsonSerializer<ClassLoaderModel> {
        private ClassLoaderModelCustomJsonSerializer() {
        }

        @Override
        public JsonElement serialize(ClassLoaderModel classLoaderModel, Type type, JsonSerializationContext jsonSerializationContext) {
            Gson gson = new GsonBuilder().enableComplexMapKeySerialization().registerTypeAdapter((Type)((Object)Artifact.class), new ArtifactCustomJsonSerializer()).create();
            JsonObject jsonObject = (JsonObject)gson.toJsonTree(classLoaderModel);
            if (classLoaderModel.getPackages() == null || classLoaderModel.getPackages().length == 0) {
                jsonObject.remove("packages");
            }
            if (classLoaderModel.getResources() == null || classLoaderModel.getResources().length == 0) {
                jsonObject.remove("resources");
            }
            return jsonObject;
        }
    }
}

