/*
 * Copyright (c) 2017 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master Subscription
 * Agreement (or other master license agreement) separately entered into in writing between
 * you and MuleSoft. If such an agreement is not in place, you may not use the software.
 */
/*
 * Copyright (c) 2015 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master Subscription
 * Agreement (or other master license agreement) separately entered into in writing between
 * you and MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.munit.remote.api.configuration;

import java.util.ArrayList;
import java.util.List;

/**
 * Define the configuration required for mule-maven-client
 *
 * @author Mulesoft Inc.
 * @since 2.0.0
 */
public class MavenConfiguration {

  private final String settingsXmlFilePath;
  private final String globalSettingsXmlFilePath;
  private final String mavenRepositoryDirectoryPath;
  private final String securitySettingsFilePath;

  private final List<String> activeProfiles;
  private Boolean offlineMode = Boolean.FALSE;
  private Boolean forcePolicyUpdate = Boolean.FALSE;
  private boolean ignoreArtifactDescriptorRepositories = Boolean.TRUE;
  private final List<Repository> remoteRepositories;

  protected MavenConfiguration(String settingsXmlFilePath, String globalSettingsXmlFilePath, String mavenRepositoryDirectoryPath,
                               String securitySettingsFilePath, Boolean forcePolicyUpdate, List<String> activeProfiles,
                               Boolean offlineMode, Boolean ignoreArtifactDescriptorRepositories,
                               List<Repository> remoteRepositories) {
    this.settingsXmlFilePath = settingsXmlFilePath;
    this.globalSettingsXmlFilePath = globalSettingsXmlFilePath;
    this.mavenRepositoryDirectoryPath = mavenRepositoryDirectoryPath;
    this.securitySettingsFilePath = securitySettingsFilePath;
    this.activeProfiles = activeProfiles;
    this.offlineMode = offlineMode;
    this.forcePolicyUpdate = forcePolicyUpdate;
    this.ignoreArtifactDescriptorRepositories = ignoreArtifactDescriptorRepositories;
    this.remoteRepositories = remoteRepositories;
  }

  public String getSettingsXmlFilePath() {
    return settingsXmlFilePath;
  }

  public String getGlobalSettingsXmlFilePath() {
    return globalSettingsXmlFilePath;
  }

  public String getMavenRepositoryDirectoryPath() {
    return mavenRepositoryDirectoryPath;
  }

  public String getSecuritySettingsFilePath() {
    return securitySettingsFilePath;
  }

  public List<String> getActiveProfiles() {
    return activeProfiles;
  }

  public Boolean getOfflineMode() {
    return offlineMode;
  }

  public Boolean getForcePolicyUpdate() {
    return forcePolicyUpdate;
  }

  public boolean getIgnoreArtifactDescriptorRepositories() {
    return ignoreArtifactDescriptorRepositories;
  }

  public List<Repository> getRemoteRepositories() {
    return remoteRepositories;
  }

  /**
   * Maven Configuration Builder
   *
   * @author Mulesoft Inc.
   * @since 2.0.0
   */
  public static class MavenConfigurationBuilder {

    private String settingsXmlFilePath;
    private String globalSettingsXmlFilePath;
    private String mavenRepositoryDirectoryPath;
    private String securitySettingsFilePath;
    private List<String> activeProfiles = new ArrayList<>();
    private Boolean offlineMode = Boolean.FALSE;
    private Boolean forcePolicyUpdate = Boolean.FALSE;
    private Boolean ignoreArtifactDescriptorRepositories = Boolean.TRUE;
    private List<Repository> remoteRepositories = new ArrayList<>();

    public static MavenConfigurationBuilder from(MavenConfiguration mc) {
      MavenConfigurationBuilder builder = new MavenConfigurationBuilder();

      builder.withSettingsXmlFilePath(mc.getSettingsXmlFilePath())
          .withGlobalSettingsXmlFilePath(mc.getGlobalSettingsXmlFilePath())
          .withMavenRepositoryDirectoryPath(mc.getMavenRepositoryDirectoryPath())
          .withSecuritySettingsFilePath(mc.getSecuritySettingsFilePath())
          .withForcePolicyUpdate(mc.getForcePolicyUpdate())
          .withActiveProfiles(mc.getActiveProfiles())
          .withOfflineMode(mc.getOfflineMode());

      return builder;
    }

    public MavenConfigurationBuilder withSettingsXmlFilePath(String settingsXmlFilePath) {
      this.settingsXmlFilePath = settingsXmlFilePath;
      return this;
    }

    public MavenConfigurationBuilder withGlobalSettingsXmlFilePath(String globalSettingsXmlFilePath) {
      this.globalSettingsXmlFilePath = globalSettingsXmlFilePath;
      return this;
    }

    public MavenConfigurationBuilder withMavenRepositoryDirectoryPath(String mavenRepositoryDirectoryPath) {
      this.mavenRepositoryDirectoryPath = mavenRepositoryDirectoryPath;
      return this;
    }

    public MavenConfigurationBuilder withForcePolicyUpdate(Boolean forcePolicyUpdate) {
      this.forcePolicyUpdate = forcePolicyUpdate;
      return this;
    }

    public MavenConfigurationBuilder withActiveProfiles(List<String> activeProfiles) {
      this.activeProfiles = activeProfiles;
      return this;
    }

    public MavenConfigurationBuilder withOfflineMode(Boolean offlineMode) {
      this.offlineMode = offlineMode;
      return this;
    }

    public MavenConfigurationBuilder withIgnoreArtifactDescriptorRepositories(Boolean ignoreArtifactDescriptorRepositories) {
      this.ignoreArtifactDescriptorRepositories = ignoreArtifactDescriptorRepositories;
      return this;
    }

    public MavenConfigurationBuilder withSecuritySettingsFilePath(String securitySettingsFilePath) {
      this.securitySettingsFilePath = securitySettingsFilePath;
      return this;
    }

    public MavenConfigurationBuilder withRemoteRepositories(List<Repository> remoteRepositories) {
      this.remoteRepositories = remoteRepositories;
      return this;
    }

    public MavenConfiguration build() {
      return new MavenConfiguration(settingsXmlFilePath, globalSettingsXmlFilePath, mavenRepositoryDirectoryPath,
                                    securitySettingsFilePath, forcePolicyUpdate, activeProfiles,
                                    offlineMode, ignoreArtifactDescriptorRepositories,
                                    remoteRepositories);
    }
  }
}
