/*
 * Copyright (c) 2017 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master Subscription
 * Agreement (or other master license agreement) separately entered into in writing between
 * you and MuleSoft. If such an agreement is not in place, you may not use the software.
 */

package org.mule.munit.remote.container;

import org.mule.munit.remote.exception.DeploymentException;

import java.util.Map;

/**
 * Interface for all Containers
 *
 * @author Mulesoft Inc.
 * @since 2.3.0
 */
public interface Container {

  String MUNIT_DISABLE_LAZY_CONNECTIONS = "munit.disable.lazy.connections";
  String MUNIT_DISABLE_LAZY_INITIALIZATION = "munit.disable.lazy.initialization";

  void start();

  void stop();

  /**
   * @return the version if the Mule runtime this embedded container is running.
   */
  String getMuleContainerVersion();

  void deployDomain() throws DeploymentException;

  void deployApplication(boolean enableXmlValidations, Map<String, Object> systemProperties)
      throws DeploymentException;

  void undeployApplication(Map<String, Object> systemProperties);

  static Boolean enableLazyConnections() {
    return !Boolean.parseBoolean(System.getProperty(MUNIT_DISABLE_LAZY_CONNECTIONS, "false"));
  }

  static Boolean enableLazyInitialization() {
    return !Boolean.parseBoolean(System.getProperty(MUNIT_DISABLE_LAZY_INITIALIZATION, "false"));
  }
}
