/*
 * Decompiled with CFR 0.152.
 */
package com.owlike.genson.ext.jaxrs;

import com.owlike.genson.Context;
import com.owlike.genson.GenericType;
import com.owlike.genson.Genson;
import com.owlike.genson.JsonBindingException;
import com.owlike.genson.annotation.WithBeanView;
import com.owlike.genson.ext.jaxrs.GensonJaxRSFeature;
import com.owlike.genson.stream.JsonStreamException;
import com.owlike.genson.stream.ObjectReader;
import com.owlike.genson.stream.ObjectWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Arrays;
import javax.ws.rs.Consumes;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.ContextResolver;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.Provider;
import javax.ws.rs.ext.Providers;

@Provider
@Consumes(value={"application/json", "text/json", "application/*+json"})
@Produces(value={"application/json", "text/json", "application/*+json"})
public class GensonJsonConverter
implements MessageBodyReader<Object>,
MessageBodyWriter<Object> {
    private final ContextResolver<GensonJaxRSFeature> _gensonResolver;

    public GensonJsonConverter() {
        this(new GensonJaxRSFeature());
    }

    public GensonJsonConverter(@javax.ws.rs.core.Context Providers providers) {
        ContextResolver<Genson> oldResolver;
        GensonJaxRSFeature gensonResolver = providers.getContextResolver(GensonJaxRSFeature.class, null);
        if (gensonResolver == null && (oldResolver = providers.getContextResolver(Genson.class, null)) != null) {
            gensonResolver = new GensonJaxRSFeature().use(oldResolver.getContext(Object.class));
        }
        this._gensonResolver = gensonResolver == null ? new GensonJaxRSFeature() : gensonResolver;
    }

    public GensonJsonConverter(ContextResolver<GensonJaxRSFeature> gensonResolver) {
        this._gensonResolver = gensonResolver;
    }

    private Genson getInstance(Class<?> type) {
        Genson genson = this._gensonResolver.getContext(type).genson();
        if (genson == null) {
            throw new NullPointerException("Could not resolve a Genson instance for type " + type + " using ContextResolver " + this._gensonResolver.getClass());
        }
        return genson;
    }

    @Override
    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        GensonJaxRSFeature feature = this._gensonResolver.getContext(type);
        return feature.isEnabled() && feature.isSerializable(type);
    }

    @Override
    public void writeTo(Object t2, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException, WebApplicationException {
        Genson genson = this.getInstance(type);
        String charset = mediaType.getParameters().get("charset");
        if (charset == null) {
            charset = "UTF-8";
        }
        if (!(charset.equalsIgnoreCase("UTF-8") || charset.equalsIgnoreCase("UTF-16BE") || charset.equalsIgnoreCase("UTF-16LE") || charset.equalsIgnoreCase("UTF-32BE") || charset.equalsIgnoreCase("UTF-32LE"))) {
            throw new UnsupportedEncodingException("JSON spec allows only UTF-8/16/32 encodings.");
        }
        ObjectWriter writer = genson.createWriter(new OutputStreamWriter(entityStream, charset));
        try {
            genson.serialize(t2, this.rawIfNullGenericType(type, genericType), writer, this.createContext(annotations, genson));
            writer.flush();
        }
        catch (JsonBindingException e) {
            throw new WebApplicationException(e);
        }
        catch (JsonStreamException jse) {
            throw new WebApplicationException(jse);
        }
    }

    private Context createContext(Annotation[] annotations, Genson genson) {
        WithBeanView viewAnno = this.find(WithBeanView.class, annotations);
        Context context = null;
        context = viewAnno != null ? new Context(genson, Arrays.asList(viewAnno.views())) : new Context(genson);
        return context;
    }

    private <T extends Annotation> T find(Class<T> annotationClass, Annotation[] inAnnotations) {
        if (inAnnotations != null) {
            for (Annotation anno : inAnnotations) {
                if (!annotationClass.isInstance(anno)) continue;
                return (T)((Annotation)annotationClass.cast(anno));
            }
        }
        return null;
    }

    @Override
    public boolean isReadable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        GensonJaxRSFeature feature = this._gensonResolver.getContext(type);
        return feature.isEnabled() && feature.isDeserializable(type);
    }

    @Override
    public Object readFrom(Class<Object> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> httpHeaders, InputStream entityStream) throws IOException, WebApplicationException {
        try {
            Genson genson = this.getInstance(type);
            ObjectReader reader = genson.createReader(entityStream);
            return genson.deserialize(GenericType.of(this.rawIfNullGenericType(type, genericType)), reader, this.createContext(annotations, genson));
        }
        catch (JsonBindingException e) {
            throw new WebApplicationException(e);
        }
        catch (JsonStreamException jse) {
            throw new WebApplicationException(jse);
        }
    }

    @Override
    public long getSize(Object t2, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return -1L;
    }

    private Type rawIfNullGenericType(Class<?> rawType, Type genericType) {
        return genericType != null ? genericType : rawType;
    }
}

