/*
 * Decompiled with CFR 0.152.
 */
package com.owlike.genson.ext.jsr353;

import com.owlike.genson.ext.jsr353.JSR353Bundle;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Spliterator;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import java.util.stream.Stream;
import javax.json.JsonArray;
import javax.json.JsonNumber;
import javax.json.JsonObject;
import javax.json.JsonString;
import javax.json.JsonValue;

class GensonJsonArray
implements JsonArray {
    private final List<JsonValue> values;

    GensonJsonArray(List<JsonValue> values) {
        this.values = values;
    }

    @Override
    public JsonObject getJsonObject(int index) {
        return (JsonObject)JsonObject.class.cast(this.values.get(index));
    }

    @Override
    public JsonArray getJsonArray(int index) {
        return (JsonArray)JsonArray.class.cast(this.values.get(index));
    }

    @Override
    public JsonNumber getJsonNumber(int index) {
        return (JsonNumber)JsonNumber.class.cast(this.values.get(index));
    }

    @Override
    public JsonString getJsonString(int index) {
        return (JsonString)JsonString.class.cast(this.values.get(index));
    }

    @Override
    public <T extends JsonValue> List<T> getValuesAs(Class<T> clazz) {
        return this.values;
    }

    @Override
    public String getString(int index) {
        return this.getJsonString(index).getString();
    }

    @Override
    public String getString(int index, String defaultValue) {
        if (this.isNull(index)) {
            return defaultValue;
        }
        return this.getString(index);
    }

    @Override
    public int getInt(int index) {
        return this.getJsonNumber(index).intValue();
    }

    @Override
    public int getInt(int index, int defaultValue) {
        if (this.isNull(index)) {
            return defaultValue;
        }
        return this.getInt(index);
    }

    @Override
    public boolean getBoolean(int index) {
        JsonValue value = this.values.get(index);
        if (JsonValue.TRUE.equals(value)) {
            return true;
        }
        if (JsonValue.FALSE.equals(value)) {
            return false;
        }
        throw new ClassCastException();
    }

    @Override
    public boolean getBoolean(int index, boolean defaultValue) {
        if (this.isNull(index)) {
            return defaultValue;
        }
        return this.getBoolean(index);
    }

    @Override
    public boolean isNull(int index) {
        return JsonValue.NULL.equals(this.values.get(index));
    }

    @Override
    public JsonValue.ValueType getValueType() {
        return JsonValue.ValueType.ARRAY;
    }

    @Override
    public int size() {
        return this.values.size();
    }

    @Override
    public boolean isEmpty() {
        return this.values.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.values.contains(o);
    }

    @Override
    public Iterator<JsonValue> iterator() {
        return this.values.iterator();
    }

    @Override
    public Object[] toArray() {
        return this.values.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.values.toArray(a);
    }

    @Override
    public boolean add(JsonValue jsonValue) {
        return this.values.add(jsonValue);
    }

    @Override
    public boolean remove(Object o) {
        return this.values.remove(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.values.containsAll(c);
    }

    @Override
    public boolean addAll(Collection<? extends JsonValue> c) {
        return this.values.addAll(c);
    }

    @Override
    public boolean addAll(int index, Collection<? extends JsonValue> c) {
        return this.values.addAll(index, c);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return this.values.removeAll(c);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.values.retainAll(c);
    }

    @Override
    public void replaceAll(UnaryOperator<JsonValue> operator) {
        this.values.replaceAll(operator);
    }

    @Override
    public void sort(Comparator<? super JsonValue> c) {
        this.values.sort(c);
    }

    @Override
    public void clear() {
        this.values.clear();
    }

    @Override
    public JsonValue get(int index) {
        return this.values.get(index);
    }

    @Override
    public JsonValue set(int index, JsonValue element) {
        return this.values.set(index, element);
    }

    @Override
    public void add(int index, JsonValue element) {
        this.values.add(index, element);
    }

    @Override
    public JsonValue remove(int index) {
        return this.values.remove(index);
    }

    @Override
    public int indexOf(Object o) {
        return this.values.indexOf(o);
    }

    @Override
    public int lastIndexOf(Object o) {
        return this.values.lastIndexOf(o);
    }

    @Override
    public ListIterator<JsonValue> listIterator() {
        return this.values.listIterator();
    }

    @Override
    public ListIterator<JsonValue> listIterator(int index) {
        return this.values.listIterator(index);
    }

    @Override
    public List<JsonValue> subList(int fromIndex, int toIndex) {
        return this.values.subList(fromIndex, toIndex);
    }

    @Override
    public Spliterator<JsonValue> spliterator() {
        return this.values.spliterator();
    }

    @Override
    public boolean removeIf(Predicate<? super JsonValue> filter) {
        return this.values.removeIf(filter);
    }

    @Override
    public Stream<JsonValue> stream() {
        return this.values.stream();
    }

    @Override
    public Stream<JsonValue> parallelStream() {
        return this.values.parallelStream();
    }

    @Override
    public void forEach(Consumer<? super JsonValue> action) {
        this.values.forEach(action);
    }

    @Override
    public boolean equals(Object o) {
        return this.values.equals(o);
    }

    @Override
    public int hashCode() {
        return this.values.hashCode();
    }

    @Override
    public String toString() {
        return JSR353Bundle.toString(this);
    }
}

