/*
 * Decompiled with CFR 0.152.
 */
package com.owlike.genson.ext.jsr353;

import com.owlike.genson.ext.jsr353.GensonJsonArray;
import com.owlike.genson.ext.jsr353.GensonJsonNumber;
import com.owlike.genson.ext.jsr353.GensonJsonObject;
import com.owlike.genson.ext.jsr353.GensonJsonString;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.json.JsonArray;
import javax.json.JsonArrayBuilder;
import javax.json.JsonBuilderFactory;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import javax.json.JsonValue;

public class GensonJsonBuilderFactory
implements JsonBuilderFactory {
    @Override
    public JsonObjectBuilder createObjectBuilder() {
        return new JsonObjectBuilder(){
            private final Map<String, JsonValue> values = new LinkedHashMap<String, JsonValue>();

            @Override
            public JsonObjectBuilder add(String name, JsonValue value) {
                if (value == null) {
                    this.addNull(name);
                } else {
                    this.values.put(name, value);
                }
                return this;
            }

            @Override
            public JsonObjectBuilder add(String name, String value) {
                if (value == null) {
                    return this.addNull(name);
                }
                return this.add(name, new GensonJsonString(value));
            }

            @Override
            public JsonObjectBuilder add(String name, BigInteger value) {
                if (value == null) {
                    return this.addNull(name);
                }
                return this.add(name, new GensonJsonNumber.IntJsonNumber(value));
            }

            @Override
            public JsonObjectBuilder add(String name, BigDecimal value) {
                if (value == null) {
                    return this.addNull(name);
                }
                return this.add(name, new GensonJsonNumber.DoubleJsonNumber(value));
            }

            @Override
            public JsonObjectBuilder add(String name, int value) {
                return this.add(name, new GensonJsonNumber.IntJsonNumber(value));
            }

            @Override
            public JsonObjectBuilder add(String name, long value) {
                return this.add(name, new GensonJsonNumber.IntJsonNumber(value));
            }

            @Override
            public JsonObjectBuilder add(String name, double value) {
                return this.add(name, new GensonJsonNumber.DoubleJsonNumber(value));
            }

            @Override
            public JsonObjectBuilder add(String name, boolean value) {
                return this.add(name, value ? JsonValue.TRUE : JsonValue.FALSE);
            }

            @Override
            public JsonObjectBuilder addNull(String name) {
                return this.add(name, JsonValue.NULL);
            }

            @Override
            public JsonObjectBuilder add(String name, JsonObjectBuilder builder) {
                if (builder == null) {
                    return this.addNull(name);
                }
                return this.add(name, builder.build());
            }

            @Override
            public JsonObjectBuilder add(String name, JsonArrayBuilder builder) {
                if (builder == null) {
                    return this.addNull(name);
                }
                return this.add(name, builder.build());
            }

            @Override
            public JsonObject build() {
                return new GensonJsonObject(Collections.unmodifiableMap(this.values));
            }
        };
    }

    @Override
    public JsonArrayBuilder createArrayBuilder() {
        return new JsonArrayBuilder(){
            private final List<JsonValue> values = new ArrayList<JsonValue>();

            @Override
            public JsonArrayBuilder add(JsonValue value) {
                if (value == null) {
                    this.addNull();
                } else {
                    this.values.add(value);
                }
                return this;
            }

            @Override
            public JsonArrayBuilder add(String value) {
                if (value == null) {
                    return this.addNull();
                }
                return this.add(new GensonJsonString(value));
            }

            @Override
            public JsonArrayBuilder add(BigDecimal value) {
                if (value == null) {
                    return this.addNull();
                }
                return this.add(new GensonJsonNumber.DoubleJsonNumber(value));
            }

            @Override
            public JsonArrayBuilder add(BigInteger value) {
                if (value == null) {
                    return this.addNull();
                }
                return this.add(new GensonJsonNumber.IntJsonNumber(value));
            }

            @Override
            public JsonArrayBuilder add(int value) {
                return this.add(new GensonJsonNumber.IntJsonNumber(value));
            }

            @Override
            public JsonArrayBuilder add(long value) {
                return this.add(new GensonJsonNumber.IntJsonNumber(value));
            }

            @Override
            public JsonArrayBuilder add(double value) {
                return this.add(new GensonJsonNumber.DoubleJsonNumber(value));
            }

            @Override
            public JsonArrayBuilder add(boolean value) {
                return this.add(value ? JsonValue.TRUE : JsonValue.FALSE);
            }

            @Override
            public JsonArrayBuilder addNull() {
                return this.add(JsonValue.NULL);
            }

            @Override
            public JsonArrayBuilder add(JsonObjectBuilder builder) {
                if (builder == null) {
                    return this.addNull();
                }
                return this.add(builder.build());
            }

            @Override
            public JsonArrayBuilder add(JsonArrayBuilder builder) {
                if (builder == null) {
                    return this.addNull();
                }
                return this.add(builder.build());
            }

            @Override
            public JsonArray build() {
                return new GensonJsonArray(Collections.unmodifiableList(this.values));
            }
        };
    }

    @Override
    public Map<String, ?> getConfigInUse() {
        return Collections.emptyMap();
    }
}

