/*
 * Decompiled with CFR 0.152.
 */
package io.takari.aether.concurrency;

import io.takari.aether.concurrency.LockingFileProcessor;
import io.takari.filemanager.FileManager;
import io.takari.filemanager.Lock;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TreeSet;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.SyncContext;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.metadata.Metadata;
import org.eclipse.aether.repository.LocalRepositoryManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class LockingSyncContext
implements SyncContext {
    private static final char SEPARATOR = '~';
    private Logger logger = LoggerFactory.getLogger(LockingFileProcessor.class);
    private final FileManager fileLockManager;
    private final LocalRepositoryManager localRepoMan;
    private final boolean shared;
    private final Map<String, Lock> locks = new LinkedHashMap<String, Lock>();

    public LockingSyncContext(boolean shared, RepositorySystemSession session, FileManager fileLockManager, Logger logger) {
        this.shared = shared;
        this.logger = logger;
        this.fileLockManager = fileLockManager;
        this.localRepoMan = session.getLocalRepositoryManager();
    }

    @Override
    public void acquire(Collection<? extends Artifact> artifacts, Collection<? extends Metadata> metadatas) {
        TreeSet<String> paths = new TreeSet<String>();
        this.addArtifactPaths(paths, artifacts);
        this.addMetadataPaths(paths, metadatas);
        File basedir = this.getLockBasedir();
        for (String path : paths) {
            File file = new File(basedir, path);
            Lock lock = this.locks.get(path);
            if (lock != null) continue;
            lock = this.shared ? this.fileLockManager.readLock(file) : this.fileLockManager.writeLock(file);
            this.locks.put(path, lock);
            try {
                lock.lock();
            }
            catch (IOException e) {
                this.logger.warn("Failed to lock file " + lock.getFile() + ": " + e);
            }
        }
    }

    private File getLockBasedir() {
        return new File(this.localRepoMan.getRepository().getBasedir(), ".locks");
    }

    private void addArtifactPaths(Collection<String> paths, Collection<? extends Artifact> artifacts) {
        if (artifacts != null) {
            for (Artifact artifact : artifacts) {
                String path = this.getPath(artifact);
                paths.add(path);
            }
        }
    }

    private String getPath(Artifact artifact) {
        StringBuilder path = new StringBuilder(128);
        path.append(artifact.getGroupId()).append('~');
        path.append(artifact.getArtifactId()).append('~');
        path.append(artifact.getBaseVersion());
        return path.toString();
    }

    private void addMetadataPaths(Collection<String> paths, Collection<? extends Metadata> metadatas) {
        if (metadatas != null) {
            for (Metadata metadata : metadatas) {
                String path = this.getPath(metadata);
                paths.add(path);
            }
        }
    }

    private String getPath(Metadata metadata) {
        StringBuilder path = new StringBuilder(128);
        if (metadata.getGroupId().length() > 0) {
            path.append(metadata.getGroupId());
            if (metadata.getArtifactId().length() > 0) {
                path.append('~').append(metadata.getArtifactId());
                if (metadata.getVersion().length() > 0) {
                    path.append('~').append(metadata.getVersion());
                }
            }
        }
        return path.toString();
    }

    @Override
    public void close() {
        for (Lock lock : this.locks.values()) {
            try {
                lock.unlock();
            }
            catch (IOException e) {
                this.logger.warn("Failed to unlock file " + lock.getFile() + ": " + e);
            }
        }
        this.locks.clear();
    }
}

