/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.archiver.xz;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import javax.annotation.Nonnull;
import org.apache.commons.compress.compressors.xz.XZCompressorInputStream;
import org.codehaus.plexus.archiver.AbstractUnArchiver;
import org.codehaus.plexus.archiver.ArchiverException;
import org.codehaus.plexus.archiver.util.Streams;

public class XZUnArchiver
extends AbstractUnArchiver {
    private static final String OPERATION_XZ = "xz";

    public XZUnArchiver() {
    }

    public XZUnArchiver(File source) {
        super(source);
    }

    @Override
    protected void execute() throws ArchiverException {
        if (this.getSourceFile().lastModified() > this.getDestFile().lastModified()) {
            this.getLogger().info("Expanding " + this.getSourceFile().getAbsolutePath() + " to " + this.getDestFile().getAbsolutePath());
            Streams.copyFully(XZUnArchiver.getXZInputStream(Streams.bufferedInputStream(Streams.fileInputStream(this.getSourceFile(), OPERATION_XZ))), Streams.bufferedOutputStream(Streams.fileOutputStream(this.getDestFile(), OPERATION_XZ)), OPERATION_XZ);
        }
    }

    @Nonnull
    public static XZCompressorInputStream getXZInputStream(InputStream in) throws ArchiverException {
        try {
            return new XZCompressorInputStream(in);
        }
        catch (IOException ioe) {
            throw new ArchiverException("Trouble creating BZIP2 compressor, invalid file ?", ioe);
        }
    }

    @Override
    protected void execute(String path, File outputDirectory) throws ArchiverException {
        throw new UnsupportedOperationException("Targeted execution not supported in xz format");
    }
}

