/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jaxb;

import java.lang.reflect.Array;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.HashMap;
import java.util.Map;

public class GenericsClassHelper {
    public static Type[] getParameterizedTypeArguments(Class concrete, Class classOrIface) {
        DeclaringClassInterfacePair declaringClassInterfacePair = GenericsClassHelper.getClass(concrete, classOrIface);
        if (declaringClassInterfacePair != null) {
            return GenericsClassHelper.getParameterizedTypeArguments(declaringClassInterfacePair);
        }
        return null;
    }

    private static Type[] getParameterizedTypeArguments(DeclaringClassInterfacePair p) {
        if (p.genericInterface instanceof ParameterizedType) {
            ParameterizedType pt = (ParameterizedType)p.genericInterface;
            Type[] as = pt.getActualTypeArguments();
            Type[] ras = new Type[as.length];
            int i = 0;
            while (i < as.length) {
                ClassTypePair ctp;
                Type a = as[i];
                if (a instanceof Class) {
                    ras[i] = a;
                } else if (a instanceof ParameterizedType) {
                    pt = (ParameterizedType)a;
                    ras[i] = a;
                } else if (a instanceof TypeVariable && (ctp = GenericsClassHelper.resolveTypeVariable(p.concreteClass, p.declaringClass, (TypeVariable)a)) != null) {
                    ras[i] = ctp.t;
                }
                ++i;
            }
            return ras;
        }
        return null;
    }

    private static DeclaringClassInterfacePair getClass(Class concrete, Class classOrIface) {
        return GenericsClassHelper.getClass(concrete, classOrIface, concrete);
    }

    private static DeclaringClassInterfacePair getClass(Class concrete, Class classOrIface, Class c) {
        DeclaringClassInterfacePair p;
        Type[] gis = null;
        if (c.getGenericSuperclass() != null) {
            gis = new Type[]{c.getGenericSuperclass()};
        }
        if (gis == null) {
            gis = c.getGenericInterfaces();
        }
        if ((p = GenericsClassHelper.getType(concrete, classOrIface, c, gis)) != null) {
            return p;
        }
        if ((c = c.getSuperclass()) == null || c == Object.class) {
            return null;
        }
        return GenericsClassHelper.getClass(concrete, classOrIface, c);
    }

    private static DeclaringClassInterfacePair getType(Class concrete, Class classOrIface, Class c, Type[] ts) {
        Type[] typeArray = ts;
        int n = ts.length;
        int n2 = 0;
        while (n2 < n) {
            Type t2 = typeArray[n2];
            DeclaringClassInterfacePair p = GenericsClassHelper.getType(concrete, classOrIface, c, t2);
            if (p != null) {
                return p;
            }
            ++n2;
        }
        return null;
    }

    private static DeclaringClassInterfacePair getType(Class concrete, Class classOrIface, Class c, Type t2) {
        if (t2 instanceof Class) {
            if (t2 == classOrIface) {
                return new DeclaringClassInterfacePair(concrete, c, t2);
            }
            return GenericsClassHelper.getClass(concrete, classOrIface, (Class)t2);
        }
        if (t2 instanceof ParameterizedType) {
            ParameterizedType pt = (ParameterizedType)t2;
            if (pt.getRawType() == classOrIface) {
                return new DeclaringClassInterfacePair(concrete, c, t2);
            }
            return GenericsClassHelper.getClass(concrete, classOrIface, (Class)pt.getRawType());
        }
        return null;
    }

    private static ClassTypePair resolveTypeVariable(Class c, Class dc, TypeVariable tv) {
        return GenericsClassHelper.resolveTypeVariable(c, dc, tv, new HashMap<TypeVariable, Type>());
    }

    private static ClassTypePair resolveTypeVariable(Class c, Class dc, TypeVariable tv, Map<TypeVariable, Type> map) {
        Type[] gis;
        Type[] typeArray = gis = c.getGenericInterfaces();
        int n = gis.length;
        int n2 = 0;
        while (n2 < n) {
            ParameterizedType pt;
            ClassTypePair ctp;
            Type gi = typeArray[n2];
            if (gi instanceof ParameterizedType && (ctp = GenericsClassHelper.resolveTypeVariable(pt = (ParameterizedType)gi, (Class)pt.getRawType(), dc, tv, map)) != null) {
                return ctp;
            }
            ++n2;
        }
        Type gsc = c.getGenericSuperclass();
        if (gsc instanceof ParameterizedType) {
            ParameterizedType pt = (ParameterizedType)gsc;
            return GenericsClassHelper.resolveTypeVariable(pt, c.getSuperclass(), dc, tv, map);
        }
        if (gsc instanceof Class) {
            return GenericsClassHelper.resolveTypeVariable(c.getSuperclass(), dc, tv, map);
        }
        return null;
    }

    private static ClassTypePair resolveTypeVariable(ParameterizedType pt, Class c, Class dc, TypeVariable tv, Map<TypeVariable, Type> map) {
        Type[] typeArguments = pt.getActualTypeArguments();
        TypeVariable<Class<T>>[] typeParameters = c.getTypeParameters();
        HashMap<TypeVariable, Type> submap = new HashMap<TypeVariable, Type>();
        int i = 0;
        while (i < typeArguments.length) {
            if (typeArguments[i] instanceof TypeVariable) {
                Type t2 = map.get(typeArguments[i]);
                submap.put(typeParameters[i], t2);
            } else {
                submap.put(typeParameters[i], typeArguments[i]);
            }
            ++i;
        }
        if (c == dc) {
            Type t3 = (Type)submap.get(tv);
            if (t3 instanceof Class) {
                return new ClassTypePair((Class)t3);
            }
            if (t3 instanceof GenericArrayType) {
                if ((t3 = ((GenericArrayType)t3).getGenericComponentType()) instanceof Class) {
                    c = (Class)t3;
                    try {
                        return new ClassTypePair(GenericsClassHelper.getArrayClass(c));
                    }
                    catch (Exception t2) {
                        return null;
                    }
                }
                if (t3 instanceof ParameterizedType) {
                    Type rt = ((ParameterizedType)t3).getRawType();
                    if (!(rt instanceof Class)) {
                        return null;
                    }
                    c = (Class)rt;
                    try {
                        return new ClassTypePair(GenericsClassHelper.getArrayClass(c), t3);
                    }
                    catch (Exception e) {
                        return null;
                    }
                }
                return null;
            }
            if (t3 instanceof ParameterizedType) {
                pt = (ParameterizedType)t3;
                if (pt.getRawType() instanceof Class) {
                    return new ClassTypePair((Class)pt.getRawType(), pt);
                }
                return null;
            }
            return null;
        }
        return GenericsClassHelper.resolveTypeVariable(c, dc, tv, submap);
    }

    protected static Class getClassOfType(Type type) {
        ParameterizedType subType;
        Type t2;
        if (type instanceof Class) {
            return (Class)type;
        }
        if (type instanceof GenericArrayType) {
            GenericArrayType arrayType = (GenericArrayType)type;
            Type t3 = arrayType.getGenericComponentType();
            if (t3 instanceof Class) {
                return GenericsClassHelper.getArrayClass((Class)t3);
            }
        } else if (type instanceof ParameterizedType && (t2 = (subType = (ParameterizedType)type).getRawType()) instanceof Class) {
            return (Class)t2;
        }
        return null;
    }

    private static Class getArrayClass(Class c) {
        try {
            Object o = Array.newInstance(c, 0);
            return o.getClass();
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }

    private static class ClassTypePair {
        public final Type t;

        public ClassTypePair(Class c) {
            this(c, c);
        }

        public ClassTypePair(Class c, Type t2) {
            this.t = t2;
        }
    }

    private static class DeclaringClassInterfacePair {
        public final Class concreteClass;
        public final Class declaringClass;
        public final Type genericInterface;

        private DeclaringClassInterfacePair(Class concreteClass, Class declaringClass, Type genericInteface) {
            this.concreteClass = concreteClass;
            this.declaringClass = declaringClass;
            this.genericInterface = genericInteface;
        }
    }
}

