/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.oxm.record;

import java.math.BigDecimal;
import java.math.BigInteger;
import javax.json.Json;
import javax.json.JsonArrayBuilder;
import javax.json.JsonObjectBuilder;
import javax.xml.namespace.QName;
import org.eclipse.persistence.internal.core.helper.CoreClassConstants;
import org.eclipse.persistence.internal.oxm.ConversionManager;
import org.eclipse.persistence.oxm.record.JsonRecord;

public class JsonBuilderRecord
extends JsonRecord<Level> {
    private JsonObjectBuilder rootJsonObjectBuilder;
    private JsonArrayBuilder rootJsonArrayBuilder;

    public JsonBuilderRecord() {
        this.isLastEventStart = false;
    }

    public JsonBuilderRecord(JsonObjectBuilder jsonObjectBuilder) {
        this();
        this.rootJsonObjectBuilder = jsonObjectBuilder;
    }

    public JsonBuilderRecord(JsonArrayBuilder jsonArrayBuilder) {
        this();
        this.rootJsonArrayBuilder = jsonArrayBuilder;
        this.isRootArray = true;
    }

    @Override
    protected Level createNewLevel(boolean collection, Level parentLevel, boolean nestedArray) {
        return new Level(collection, (Level)this.position, nestedArray);
    }

    @Override
    protected void startRootObject() {
        super.startRootObject();
        ((Level)this.position).setJsonObjectBuilder(this.rootJsonObjectBuilder);
        this.setComplex((Level)this.position, true);
    }

    @Override
    protected void finishLevel() {
        Level parentLevel;
        if (!(((Level)this.position).isCollection && ((Level)this.position).isEmptyCollection() && ((Level)this.position).getKeyName() == null || (parentLevel = (Level)((Level)this.position).parentLevel) == null)) {
            if (parentLevel.isCollection) {
                if (((Level)this.position).isCollection) {
                    parentLevel.getJsonArrayBuilder().add(((Level)this.position).getJsonArrayBuilder());
                } else {
                    parentLevel.getJsonArrayBuilder().add(((Level)this.position).getJsonObjectBuilder());
                }
            } else if (((Level)this.position).isCollection) {
                parentLevel.getJsonObjectBuilder().add(((Level)this.position).getKeyName(), ((Level)this.position).getJsonArrayBuilder());
            } else {
                parentLevel.getJsonObjectBuilder().add(((Level)this.position).getKeyName(), ((Level)this.position).getJsonObjectBuilder());
            }
        }
        super.finishLevel();
    }

    @Override
    protected void startRootLevelCollection() {
        if (this.rootJsonArrayBuilder == null) {
            this.rootJsonArrayBuilder = Json.createArrayBuilder();
        }
        ((Level)this.position).setJsonArrayBuilder(this.rootJsonArrayBuilder);
    }

    @Override
    public void endCollection() {
        this.finishLevel();
    }

    @Override
    protected void setComplex(Level level, boolean complex) {
        boolean isAlreadyComplex = level.isComplex;
        super.setComplex(level, complex);
        if (complex && !isAlreadyComplex && level.jsonObjectBuilder == null) {
            level.jsonObjectBuilder = Json.createObjectBuilder();
        }
    }

    @Override
    protected void writeEmptyCollection(Level level, String keyName) {
        level.getJsonObjectBuilder().add(keyName, Json.createArrayBuilder());
    }

    @Override
    protected void addValueToObject(Level level, String keyName, Object value, QName schemaType) {
        JsonObjectBuilder jsonObjectBuilder = level.getJsonObjectBuilder();
        if (value == "null") {
            jsonObjectBuilder.addNull(keyName);
        } else if (value instanceof Integer) {
            jsonObjectBuilder.add(keyName, (Integer)value);
        } else if (value instanceof BigDecimal) {
            jsonObjectBuilder.add(keyName, (BigDecimal)value);
        } else if (value instanceof BigInteger) {
            jsonObjectBuilder.add(keyName, (BigInteger)value);
        } else if (value instanceof Boolean) {
            jsonObjectBuilder.add(keyName, (Boolean)value);
        } else if (value instanceof Character) {
            jsonObjectBuilder.add(keyName, ((Character)value).charValue());
        } else if (value instanceof Double) {
            jsonObjectBuilder.add(keyName, (Double)value);
        } else if (value instanceof Float) {
            jsonObjectBuilder.add(keyName, ((Float)value).floatValue());
        } else if (value instanceof Long) {
            jsonObjectBuilder.add(keyName, (Long)value);
        } else if (value instanceof String) {
            jsonObjectBuilder.add(keyName, (String)value);
        } else {
            ConversionManager conversionManager = this.getConversionManager();
            String convertedValue = (String)conversionManager.convertObject(value, CoreClassConstants.STRING, schemaType);
            Class<?> theClass = conversionManager.javaType(schemaType);
            if ((schemaType == null || theClass == null) && CoreClassConstants.NUMBER.isAssignableFrom(value.getClass())) {
                BigDecimal convertedNumberValue = (BigDecimal)((ConversionManager)this.session.getDatasourcePlatform().getConversionManager()).convertObject(value, CoreClassConstants.BIGDECIMAL, schemaType);
                jsonObjectBuilder.add(keyName, convertedNumberValue);
            } else {
                jsonObjectBuilder.add(keyName, convertedValue);
            }
        }
    }

    @Override
    protected void addValueToArray(Level level, Object value, QName schemaType) {
        JsonArrayBuilder jsonArrayBuilder = level.getJsonArrayBuilder();
        if (value == "null") {
            jsonArrayBuilder.addNull();
        } else if (value instanceof Integer) {
            jsonArrayBuilder.add((Integer)value);
        } else if (value instanceof BigDecimal) {
            jsonArrayBuilder.add((BigDecimal)value);
        } else if (value instanceof BigInteger) {
            jsonArrayBuilder.add((BigInteger)value);
        } else if (value instanceof Boolean) {
            jsonArrayBuilder.add((Boolean)value);
        } else if (value instanceof Character) {
            jsonArrayBuilder.add(((Character)value).charValue());
        } else if (value instanceof Double) {
            jsonArrayBuilder.add((Double)value);
        } else if (value instanceof Float) {
            jsonArrayBuilder.add(((Float)value).floatValue());
        } else if (value instanceof Long) {
            jsonArrayBuilder.add((Long)value);
        } else if (value instanceof String) {
            jsonArrayBuilder.add((String)value);
        } else {
            ConversionManager conversionManager = this.getConversionManager();
            String convertedValue = (String)conversionManager.convertObject(value, CoreClassConstants.STRING, schemaType);
            Class<?> theClass = conversionManager.javaType(schemaType);
            if ((schemaType == null || theClass == null) && CoreClassConstants.NUMBER.isAssignableFrom(value.getClass())) {
                BigDecimal convertedNumberValue = (BigDecimal)((ConversionManager)this.session.getDatasourcePlatform().getConversionManager()).convertObject(value, CoreClassConstants.BIGDECIMAL, schemaType);
                jsonArrayBuilder.add(convertedNumberValue);
            } else {
                jsonArrayBuilder.add(convertedValue);
            }
        }
    }

    protected static class Level
    extends JsonRecord.Level {
        private JsonObjectBuilder jsonObjectBuilder;
        private JsonArrayBuilder jsonArrayBuilder;

        public Level(boolean isCollection, Level position, boolean nestedArray) {
            super(isCollection, position, nestedArray);
        }

        @Override
        public void setCollection(boolean isCollection) {
            super.setCollection(isCollection);
            if (isCollection && this.jsonArrayBuilder == null) {
                this.jsonArrayBuilder = Json.createArrayBuilder();
            }
        }

        public JsonObjectBuilder getJsonObjectBuilder() {
            return this.jsonObjectBuilder;
        }

        public void setJsonObjectBuilder(JsonObjectBuilder jsonObjectBuilder) {
            this.jsonObjectBuilder = jsonObjectBuilder;
        }

        public JsonArrayBuilder getJsonArrayBuilder() {
            return this.jsonArrayBuilder;
        }

        public void setJsonArrayBuilder(JsonArrayBuilder jsonArrayBuilder) {
            this.jsonArrayBuilder = jsonArrayBuilder;
        }
    }
}

