/*
 * Decompiled with CFR 0.152.
 */
package org.mule.maven.client.internal.util;

import org.eclipse.aether.util.version.GenericVersionScheme;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MavenVersionUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(MavenVersionUtils.class);
    public static final boolean IS_MAVEN_VERSION_38 = MavenVersionUtils.isMavenVersion38();

    private MavenVersionUtils() {
    }

    private static boolean isMavenVersion38() {
        GenericVersionScheme genericVersionScheme = new GenericVersionScheme();
        try {
            Class<?> cl = MavenVersionUtils.class.getClassLoader().loadClass("org.apache.maven.rtinfo.internal.DefaultRuntimeInformation");
            Object runtimeInformation = cl.newInstance();
            String mavenVersion = (String)runtimeInformation.getClass().getMethod("getMavenVersion", new Class[0]).invoke(runtimeInformation, new Object[0]);
            return genericVersionScheme.parseVersionRange("[3.8.0,3.9.0)").containsVersion(genericVersionScheme.parseVersion(mavenVersion));
        }
        catch (Exception e) {
            LOGGER.debug("Failed to obtain Maven version. Maven Client's Maven version will be used", e);
            return false;
        }
    }
}

