/*
 * Decompiled with CFR 0.152.
 */
package org.mule.metadata.internal.utils;

import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang3.builder.Builder;
import org.mule.metadata.api.model.FieldsComparable;
import org.mule.metadata.internal.utils.IDKey;

public class EfficientHashCode
implements Builder<Integer> {
    private static final int DEFAULT_INITIAL_VALUE = 17;
    private static final int DEFAULT_MULTIPLIER_VALUE = 37;
    private static final ThreadLocal<Set<IDKey>> REGISTRY = new ThreadLocal();
    private final int iConstant;
    private int iTotal = 17;

    static Set<IDKey> getRegistry() {
        return REGISTRY.get();
    }

    static boolean isRegistered(Object value) {
        Set<IDKey> registry = EfficientHashCode.getRegistry();
        return registry != null && registry.contains(new IDKey(value));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void efficientAppend(Object object, EfficientHashCode builder) {
        if (EfficientHashCode.isRegistered(object)) {
            return;
        }
        try {
            EfficientHashCode.register(object);
            if (object instanceof FieldsComparable) {
                Object[] fields;
                for (Object field : fields = ((FieldsComparable)object).getFieldValues()) {
                    EfficientHashCode.efficientAppend(field, builder);
                }
            } else if (object != null) {
                builder.append(object);
            }
        }
        finally {
            EfficientHashCode.unregister(object);
        }
    }

    public static int efficientHashcode(FieldsComparable object) {
        EfficientHashCode builder = new EfficientHashCode();
        EfficientHashCode.efficientAppend(object, builder);
        return builder.build();
    }

    private static void register(Object value) {
        Set<IDKey> registry = EfficientHashCode.getRegistry();
        if (registry == null) {
            registry = new HashSet<IDKey>();
            REGISTRY.set(registry);
        }
        registry.add(new IDKey(value));
    }

    private static void unregister(Object value) {
        Set<IDKey> registry = EfficientHashCode.getRegistry();
        if (registry != null) {
            registry.remove(new IDKey(value));
            if (registry.isEmpty()) {
                REGISTRY.remove();
            }
        }
    }

    public EfficientHashCode() {
        this.iConstant = 37;
    }

    public EfficientHashCode append(boolean value) {
        this.iTotal = this.iTotal * this.iConstant + (value ? 0 : 1);
        return this;
    }

    private EfficientHashCode append(boolean[] array) {
        for (boolean element : array) {
            this.append(element);
        }
        return this;
    }

    public EfficientHashCode append(byte value) {
        this.iTotal = this.iTotal * this.iConstant + value;
        return this;
    }

    private EfficientHashCode append(byte[] array) {
        for (byte element : array) {
            this.append(element);
        }
        return this;
    }

    public EfficientHashCode append(char value) {
        this.iTotal = this.iTotal * this.iConstant + value;
        return this;
    }

    private EfficientHashCode append(char[] array) {
        for (char element : array) {
            this.append(element);
        }
        return this;
    }

    public EfficientHashCode append(double value) {
        return this.append(Double.doubleToLongBits(value));
    }

    private EfficientHashCode append(double[] array) {
        for (double element : array) {
            this.append(element);
        }
        return this;
    }

    public EfficientHashCode append(float value) {
        this.iTotal = this.iTotal * this.iConstant + Float.floatToIntBits(value);
        return this;
    }

    private EfficientHashCode append(float[] array) {
        for (float element : array) {
            this.append(element);
        }
        return this;
    }

    public EfficientHashCode append(int value) {
        this.iTotal = this.iTotal * this.iConstant + value;
        return this;
    }

    private EfficientHashCode append(int[] array) {
        for (int element : array) {
            this.append(element);
        }
        return this;
    }

    public EfficientHashCode append(long value) {
        this.iTotal = this.iTotal * this.iConstant + (int)(value ^ value >> 32);
        return this;
    }

    private EfficientHashCode append(long[] array) {
        for (long element : array) {
            this.append(element);
        }
        return this;
    }

    public EfficientHashCode append(Object object) {
        if (object == null) {
            this.iTotal *= this.iConstant;
        } else if (object.getClass().isArray()) {
            this.appendArray(object);
        } else {
            this.iTotal = this.iTotal * this.iConstant + object.hashCode();
        }
        return this;
    }

    private void appendArray(Object object) {
        if (object instanceof long[]) {
            this.append((long[])object);
        } else if (object instanceof int[]) {
            this.append((int[])object);
        } else if (object instanceof short[]) {
            this.append((short[])object);
        } else if (object instanceof char[]) {
            this.append((char[])object);
        } else if (object instanceof byte[]) {
            this.append((byte[])object);
        } else if (object instanceof double[]) {
            this.append((double[])object);
        } else if (object instanceof float[]) {
            this.append((float[])object);
        } else if (object instanceof boolean[]) {
            this.append((boolean[])object);
        } else {
            this.append((Object[])object);
        }
    }

    private EfficientHashCode append(Object[] array) {
        for (Object element : array) {
            this.append(element);
        }
        return this;
    }

    public EfficientHashCode append(short value) {
        this.iTotal = this.iTotal * this.iConstant + value;
        return this;
    }

    private EfficientHashCode append(short[] array) {
        for (short element : array) {
            this.append(element);
        }
        return this;
    }

    @Override
    public Integer build() {
        return this.iTotal;
    }
}

