/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.plugins.coverage.report;

import com.google.common.base.Preconditions;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.mule.munit.plugins.coverage.core.model.CoverageComponentLocation;
import org.mule.munit.plugins.coverage.report.LocationGrouper;
import org.mule.munit.plugins.coverage.report.model.ApplicationCoverageReport;
import org.mule.munit.plugins.coverage.report.model.MuleFlow;
import org.mule.munit.plugins.coverage.report.model.MuleLocation;
import org.mule.munit.plugins.coverage.report.model.MuleResource;
import org.mule.runtime.api.component.location.LocationPart;

public class ApplicationCoverageReportBuilder {
    private Set<String> suitePaths;
    private Set<String> flowsToIgnore = Collections.emptySet();
    private Set<String> filesToIgnore = Collections.emptySet();
    private Set<CoverageComponentLocation> allLocations;
    private Set<CoverageComponentLocation> coveredLocations;

    public ApplicationCoverageReportBuilder(Set<CoverageComponentLocation> allLocations, Set<CoverageComponentLocation> coveredLocations, Set<String> suitePaths) {
        Preconditions.checkNotNull(allLocations, "The set of locations must not be null");
        Preconditions.checkNotNull(coveredLocations, "The set of covered locations must not be null");
        Preconditions.checkNotNull(suitePaths, "The suite path list  must not be null");
        Preconditions.checkArgument(!suitePaths.isEmpty(), "The suite path list  must not be empty");
        this.allLocations = allLocations;
        this.coveredLocations = coveredLocations;
        this.suitePaths = suitePaths;
    }

    public void setFlowsToIgnore(Set<String> flowsToIgnore) {
        Preconditions.checkNotNull(flowsToIgnore, "The set of flows to ignore must not be null");
        this.flowsToIgnore = flowsToIgnore;
    }

    public void setFilesToIgnore(Set<String> filesToIgnore) {
        Preconditions.checkNotNull(filesToIgnore, "The set of files to ignore must not be null");
        this.filesToIgnore = filesToIgnore;
    }

    public Set<String> getSuitePaths() {
        return this.suitePaths;
    }

    public Set<String> getFlowsToIgnore() {
        return this.flowsToIgnore;
    }

    public Set<String> getFilesToIgnore() {
        return this.filesToIgnore;
    }

    public Set<CoverageComponentLocation> getAllLocations() {
        return this.allLocations;
    }

    public Set<CoverageComponentLocation> getCoveredLocations() {
        return this.coveredLocations;
    }

    public ApplicationCoverageReport build() {
        return new ApplicationCoverageReport(this.createMuleResources());
    }

    private List<MuleResource> createMuleResources() {
        Map<String, Set<CoverageComponentLocation>> locationsPerFile = new LocationGrouper(this.allLocations).groupByFile();
        return locationsPerFile.entrySet().stream().filter(location -> this.isNotIgnoredFile((String)location.getKey())).filter(location -> this.isNotSuiteFile((String)location.getKey())).map(location -> this.toMuleResource((String)location.getKey(), (Set)location.getValue())).collect(Collectors.toList());
    }

    private MuleResource toMuleResource(String fileName, Set<CoverageComponentLocation> fileLocations) {
        MuleResource muleResource = new MuleResource(fileName);
        muleResource.setFlows(this.createMuleFlows(fileLocations));
        return muleResource;
    }

    private List<MuleFlow> createMuleFlows(Set<CoverageComponentLocation> locations) {
        Map<LocationPart, Set<CoverageComponentLocation>> locationsPerFlow = new LocationGrouper(locations).groupByFlow();
        return locationsPerFlow.entrySet().stream().filter(location -> this.isNotIgnoredFlow((LocationPart)location.getKey())).map(location -> this.toMuleFlow((LocationPart)location.getKey(), (Set)location.getValue())).collect(Collectors.toList());
    }

    private MuleFlow toMuleFlow(LocationPart locationPart, Set<CoverageComponentLocation> flowLocations) {
        MuleFlow muleFlow = new MuleFlow(locationPart.getPartPath());
        muleFlow.setType(locationPart.getPartIdentifier().get().getType());
        muleFlow.setLocations(flowLocations.stream().map(l -> this.toMuleLocation((CoverageComponentLocation)l)).collect(Collectors.toList()));
        muleFlow.setCoveredLocations(flowLocations.stream().filter(l -> this.coveredLocations.contains(l)).map(l -> this.toMuleLocation((CoverageComponentLocation)l)).collect(Collectors.toList()));
        return muleFlow;
    }

    private MuleLocation toMuleLocation(CoverageComponentLocation coverageComponentLocation) {
        return new MuleLocation(coverageComponentLocation.getLocation(), coverageComponentLocation.getLineInFile().orElse(-1));
    }

    private boolean isNotIgnoredFlow(LocationPart locationPart) {
        String flowName = locationPart.getPartPath();
        return !this.flowsToIgnore.contains(flowName);
    }

    private boolean isNotIgnoredFile(String fileName) {
        return !this.filesToIgnore.contains(fileName);
    }

    private boolean isNotSuiteFile(String fileName) {
        return !this.suitePaths.contains(fileName);
    }
}

