/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.plugins.coverage.report.printer;

import com.google.common.base.Preconditions;
import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Scanner;
import java.util.Vector;
import org.mule.munit.common.util.IOUtils;
import org.mule.munit.plugins.coverage.report.model.ApplicationCoverageReport;
import org.mule.munit.plugins.coverage.report.model.CoverageLimits;
import org.mule.munit.plugins.coverage.report.model.MuleFlow;
import org.mule.munit.plugins.coverage.report.model.MuleLocation;
import org.mule.munit.plugins.coverage.report.model.MuleResource;
import org.mule.munit.plugins.coverage.report.printer.CoverageReportPrinter;
import org.mule.munit.plugins.coverage.report.printer.ReportFileWriter;

public class HtmlPrinter
implements CoverageReportPrinter {
    public static final String PRINTER_NAME = "HTML";
    private static final String ASSETS_FOLDER = "assets";
    private static final String STYLES_FOLDER = "styles";
    private static final String SCRIPTS_FOLDER = "js";
    private static final String BASE_TEMPLATE_FOLDER = "/templates";
    private static final String SUMMARY_TEMPLATE_FILE_NAME = "summary.ftl";
    private static final String RESOURCE_TEMPLATE_FILE_NAME = "resource.ftl";
    private static final String MULESOFT_FLOWS = "src/main/mule";
    private static final String MULESOFT_STYLES = "mulesoft-styles.css";
    private static final String TSORTER_STYLES = "tsorter.css";
    private static final String MULESOFT_ICON = "icons/004_logo.svg";
    private static final String MULESOFT_ICON_TTF = "fonts/muleicons.ttf";
    private static final String TSORTER_SCRIPT = "tsorter.min.js";
    private final File reportDirectory;
    private CoverageLimits coverageLimits;
    private ReportFileWriter reportFileWriter = new ReportFileWriter();
    private Configuration freemarkerConfig;

    public HtmlPrinter(CoverageLimits coverageLimits, File reportDirectory) {
        Preconditions.checkNotNull(coverageLimits, "Coverage limits cannot be null");
        Preconditions.checkNotNull(reportDirectory, "Report directory cannot be null");
        this.coverageLimits = coverageLimits;
        this.reportDirectory = reportDirectory;
        this.freemarkerConfig = new Configuration(Configuration.VERSION_2_3_23);
        this.freemarkerConfig.setClassForTemplateLoading(this.getClass(), BASE_TEMPLATE_FOLDER);
    }

    @Override
    public String getPrinterName() {
        return PRINTER_NAME;
    }

    @Override
    public void printReport(ApplicationCoverageReport report) {
        try {
            this.printSummary(report);
            this.printResources(report);
            this.addAssets();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void setReportFileWriter(ReportFileWriter reportFileWriter) {
        this.reportFileWriter = reportFileWriter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void printSummary(ApplicationCoverageReport report) throws IOException {
        StringWriter writer = null;
        try {
            Template summaryTemplate = this.getTemplate(SUMMARY_TEMPLATE_FILE_NAME);
            HashMap<String, Object> data = new HashMap<String, Object>();
            data.put("applicationFlowCount", report.getApplicationFlowCount());
            data.put("applicationCoverage", report.getCoverage());
            data.put("applicationResourceLines", report.getResources());
            data.put("coverageLimits", this.coverageLimits);
            writer = new StringWriter();
            summaryTemplate.process(data, writer);
            this.reportFileWriter.writeToFile(new File(this.reportDirectory, "summary.html"), writer.getBuffer().toString());
            IOUtils.closeQuietly(writer);
        }
        catch (TemplateException e) {
            e.printStackTrace();
        }
        finally {
            IOUtils.closeQuietly(writer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void printResources(ApplicationCoverageReport report) throws IOException {
        StringWriter writer = null;
        for (MuleResource mr : report.getResources()) {
            try {
                Template resourceTemplate = this.getTemplate(RESOURCE_TEMPLATE_FILE_NAME);
                File reportFile = new File(this.reportDirectory, this.reportFileWriter.getHtmlFileName(mr.getName()));
                HashMap<String, Object> data = new HashMap<String, Object>();
                data.put("resourceName", mr.getName());
                data.put("resourceMpCovered", mr.getCoveredMessageProcessorCount());
                data.put("resourceMpCount", mr.getMessageProcessorCount());
                data.put("resourceCoverage", mr.getCoverage());
                data.put("flowLines", mr.getFlows());
                data.put("coverageLimits", this.coverageLimits);
                data.put("xmlLines", this.getXmlLines(mr.getName()));
                data.put("rootFolder", this.getRelativeRootFolder(reportFile));
                Vector<Integer> coveredLines = new Vector<Integer>();
                Vector<Integer> linesInFlow = new Vector<Integer>();
                for (MuleFlow flow : mr.getFlows()) {
                    for (MuleLocation location : flow.getCoveredLocations()) {
                        coveredLines.add(location.getLineNumber());
                    }
                    for (MuleLocation location : flow.getLocations()) {
                        linesInFlow.add(location.getLineNumber());
                    }
                }
                data.put("coveredLines", coveredLines.toArray());
                data.put("linesInFlow", linesInFlow.toArray());
                writer = new StringWriter();
                resourceTemplate.process(data, writer);
                this.reportFileWriter.writeToFile(reportFile, writer.getBuffer().toString());
                IOUtils.closeQuietly(writer);
            }
            catch (TemplateException e) {
                e.printStackTrace();
            }
            finally {
                IOUtils.closeQuietly(writer);
            }
        }
    }

    private String getRelativeRootFolder(File reportFile) {
        Path assetsPath = this.reportDirectory.toPath();
        String rootPath = reportFile.getParentFile().toPath().relativize(assetsPath).toString();
        return rootPath.equals("") ? "." : rootPath;
    }

    private List<String> getXmlLines(String file) {
        Vector<String> lines = new Vector<String>();
        File xmlFile = new File(MULESOFT_FLOWS, file);
        if (xmlFile.exists()) {
            try {
                Scanner scanner = new Scanner(xmlFile, "UTF-8");
                while (scanner.hasNextLine()) {
                    lines.add(scanner.nextLine());
                }
                scanner.close();
            }
            catch (Exception e) {
                return null;
            }
        }
        return lines;
    }

    private Template getTemplate(String resourceTemplateFileName) throws IOException {
        return this.freemarkerConfig.getTemplate(resourceTemplateFileName, Locale.US);
    }

    private void addAssets() {
        this.addStyles();
        this.addScripts();
    }

    private void addStyles() {
        try {
            Path stylesPath = this.reportDirectory.toPath().resolve(ASSETS_FOLDER).resolve(STYLES_FOLDER);
            this.reportFileWriter.copyFile(MULESOFT_STYLES, stylesPath.resolve(MULESOFT_STYLES).toFile());
            this.reportFileWriter.copyFile(MULESOFT_ICON, stylesPath.resolve(MULESOFT_ICON).toFile());
            this.reportFileWriter.copyFile(MULESOFT_ICON_TTF, stylesPath.resolve(MULESOFT_ICON_TTF).toFile());
            this.reportFileWriter.copyFile(TSORTER_STYLES, stylesPath.resolve(TSORTER_STYLES).toFile());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void addScripts() {
        try {
            Path scriptsPath = this.reportDirectory.toPath().resolve(ASSETS_FOLDER).resolve(SCRIPTS_FOLDER);
            this.reportFileWriter.copyFile(TSORTER_SCRIPT, scriptsPath.resolve(TSORTER_SCRIPT).toFile());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

