/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.remote.container;

import com.google.common.base.Preconditions;
import java.io.File;
import java.util.HashSet;
import java.util.Set;
import org.mule.munit.remote.api.configuration.RunConfiguration;
import org.mule.munit.remote.container.model.SuiteRun;
import org.mule.munit.remote.properties.DesignTimeSuitesParser;
import org.mule.munit.remote.properties.Parameterization;
import org.mule.munit.remote.properties.SuiteConfigParser;
import org.mule.runtime.api.deployment.meta.Product;

public class SuiteRunLocator {
    private static final String DESIGN_TIME_MIN_MULE_VERSION = "4.2.0";
    private RunConfiguration runConfiguration;
    private DesignTimeSuitesParser designTimeSuitesParser;
    private static File applicationDirectory;

    public SuiteRunLocator(RunConfiguration runConfiguration, File applicationDirectory) {
        Preconditions.checkArgument(runConfiguration != null, "Run configuration cannot be null");
        this.runConfiguration = runConfiguration;
        SuiteRunLocator.applicationDirectory = applicationDirectory;
        this.designTimeSuitesParser = new DesignTimeSuitesParser();
    }

    public Set<SuiteRun> locate() {
        HashSet<SuiteRun> suiteRuns = new HashSet<SuiteRun>();
        for (String suitePath : this.runConfiguration.getAllSuitePaths()) {
            File suiteFile = new File(applicationDirectory, suitePath);
            SuiteConfigParser suiteConfigParser = new SuiteConfigParser(suiteFile, applicationDirectory);
            Set<Parameterization> parameterizations = suiteConfigParser.parseParameterizations();
            boolean hasDesignTimeTests = this.designTimeSuitesParser.hasDesignTimeTests(suiteFile);
            boolean isIgnored = suiteConfigParser.isIgnored();
            String minMuleVersion = suiteConfigParser.getMinMuleVersion().orElse(hasDesignTimeTests ? DESIGN_TIME_MIN_MULE_VERSION : null);
            Product requiredProduct = suiteConfigParser.getRequiredProduct().orElse(null);
            if (parameterizations.isEmpty()) {
                suiteRuns.add(SuiteRun.builder().withSuitePath(suitePath).withDesignTime(hasDesignTimeTests).withMinMuleVersion(minMuleVersion).withIgnore(isIgnored).withRequiredProduct(requiredProduct).build());
                continue;
            }
            for (Parameterization parameterization : parameterizations) {
                suiteRuns.add(SuiteRun.builder().withSuitePath(suitePath).withParameterization(parameterization).withDesignTime(hasDesignTimeTests).withIgnore(isIgnored).withMinMuleVersion(minMuleVersion).withRequiredProduct(requiredProduct).build());
            }
        }
        return suiteRuns;
    }
}

