/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.api.meta.model;

import java.util.LinkedHashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.ObjectType;
import org.mule.runtime.api.util.Preconditions;

public final class SubTypesModel {
    private final ObjectType baseType;
    private final Set<ObjectType> subTypes;

    public SubTypesModel(MetadataType baseType, Set<MetadataType> subTypes) {
        Preconditions.checkArgument(baseType != null, "baseType cannot be null");
        Preconditions.checkArgument(baseType instanceof ObjectType, "Only ObjectTypes can be extended");
        Preconditions.checkArgument(subTypes != null && !subTypes.isEmpty(), "subTypes cannot be null nor empty");
        Preconditions.checkArgument(subTypes.stream().allMatch(s2 -> s2 instanceof ObjectType), "subTypes of an ObjectType can only be instances of ObjectType");
        this.baseType = (ObjectType)baseType;
        this.subTypes = subTypes.stream().map(s2 -> (ObjectType)s2).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    public ObjectType getBaseType() {
        return this.baseType;
    }

    public Set<ObjectType> getSubTypes() {
        return this.subTypes;
    }

    public String toString() {
        return "SubTypesModel {" + this.baseType.toString() + " <- " + this.subTypes.toString() + "}";
    }
}

