/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.api.meta.model.parameter;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.mule.api.annotation.NoExtend;
import org.mule.api.annotation.NoInstantiate;
import org.mule.runtime.api.meta.model.EnrichableModel;
import org.mule.runtime.api.meta.model.ModelProperty;
import org.mule.runtime.api.meta.model.parameter.ActingParameterModel;
import org.mule.runtime.api.util.Preconditions;

@NoExtend
@NoInstantiate
public class ValueProviderModel
implements EnrichableModel {
    private List<String> actingParameters;
    private final List<ActingParameterModel> parameters;
    private final Integer partOrder;
    private final String providerName;
    private final String providerId;
    private final boolean requiresConfiguration;
    private final boolean requiresConnection;
    private final boolean isOpen;
    private Map<Class<? extends ModelProperty>, ModelProperty> modelProperties = new LinkedHashMap<Class<? extends ModelProperty>, ModelProperty>();
    private transient Set<ModelProperty> modelPropertiesValues = new HashSet<ModelProperty>();

    public ValueProviderModel(List<ActingParameterModel> parameters, boolean requiresConfiguration, boolean requiresConnection, boolean isOpen, Integer partOrder, String providerName, String providerId) {
        Preconditions.checkArgument(parameters != null, "'parameters' can't be null");
        Preconditions.checkArgument(partOrder != null, "'valueParts' can't be null");
        Preconditions.checkArgument(providerName != null, "'providerName' can't be null");
        Preconditions.checkArgument(providerId != null, "'providerId' can't be null");
        this.isOpen = isOpen;
        this.parameters = Collections.unmodifiableList(parameters);
        this.requiresConfiguration = requiresConfiguration;
        this.requiresConnection = requiresConnection;
        this.partOrder = partOrder;
        this.providerName = providerName;
        this.providerId = providerId;
    }

    public ValueProviderModel(List<ActingParameterModel> parameters, boolean requiresConfiguration, boolean requiresConnection, boolean isOpen, Integer partOrder, String providerName, String providerId, ModelProperty ... modelProperties) {
        Preconditions.checkArgument(parameters != null, "'parameters' can't be null");
        Preconditions.checkArgument(partOrder != null, "'valueParts' can't be null");
        Preconditions.checkArgument(providerName != null, "'providerName' can't be null");
        Preconditions.checkArgument(providerId != null, "'providerId' can't be null");
        Preconditions.checkArgument(modelProperties != null, "'modelProperties' can't be null");
        this.isOpen = isOpen;
        this.parameters = Collections.unmodifiableList(parameters);
        this.requiresConfiguration = requiresConfiguration;
        this.requiresConnection = requiresConnection;
        this.partOrder = partOrder;
        this.providerName = providerName;
        this.providerId = providerId;
        this.modelProperties = Arrays.stream(modelProperties).collect(Collectors.toMap(modelProperty -> modelProperty.getClass(), modelProperty -> modelProperty));
        this.modelPropertiesValues = Collections.unmodifiableSet(new LinkedHashSet<ModelProperty>(this.modelProperties.values()));
    }

    @Deprecated
    public List<String> getActingParameters() {
        if (this.actingParameters == null) {
            this.actingParameters = this.parameters.stream().filter(ActingParameterModel::isRequired).map(ActingParameterModel::getName).collect(Collectors.toList());
        }
        return this.actingParameters;
    }

    public List<ActingParameterModel> getParameters() {
        return this.parameters;
    }

    public Integer getPartOrder() {
        return this.partOrder;
    }

    public String getProviderName() {
        return this.providerName;
    }

    public String getProviderId() {
        return this.providerId;
    }

    public boolean requiresConfiguration() {
        return this.requiresConfiguration;
    }

    public boolean requiresConnection() {
        return this.requiresConnection;
    }

    public boolean isOpen() {
        return this.isOpen;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ValueProviderModel that = (ValueProviderModel)o;
        return new EqualsBuilder().append(this.parameters, that.parameters).append(this.partOrder, that.partOrder).append(this.providerName, that.providerName).append(this.providerId, that.providerId).append(this.requiresConnection, that.requiresConnection).append(this.requiresConfiguration, that.requiresConfiguration).append(this.isOpen, that.isOpen).append(this.modelProperties, that.modelProperties).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 37).append(this.parameters).append(this.partOrder).append(this.providerName).append(this.providerId).append(this.requiresConnection).append(this.requiresConfiguration).append(this.isOpen).append(this.modelProperties).toHashCode();
    }

    @Override
    public <T extends ModelProperty> Optional<T> getModelProperty(Class<T> propertyType) {
        Preconditions.checkArgument(propertyType != null, "Cannot get model properties of a null type");
        return Optional.ofNullable(this.modelProperties.get(propertyType));
    }

    @Override
    public Set<ModelProperty> getModelProperties() {
        if (this.modelPropertiesValues == null) {
            this.modelPropertiesValues = Collections.unmodifiableSet(new LinkedHashSet<ModelProperty>(this.modelProperties.values()));
        }
        return this.modelPropertiesValues;
    }
}

