/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.internal.util.xmlsecurity;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.stream.XMLInputFactory;
import javax.xml.transform.TransformerFactory;
import javax.xml.validation.SchemaFactory;
import org.mule.runtime.internal.util.xmlsecurity.DefaultXMLSecureFactories;
import org.mule.runtime.internal.util.xmlsecurity.XMLFactoryConfig;

public class XMLSecureFactoriesCache {
    private LoadingCache<XMLFactoryConfig, Object> cache = CacheBuilder.newBuilder().build(new CacheLoader<XMLFactoryConfig, Object>(){

        @Override
        public Object load(XMLFactoryConfig key) throws Exception {
            return key.createFactory();
        }
    });
    private static volatile XMLSecureFactoriesCache instance;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static XMLSecureFactoriesCache getInstance() {
        if (instance != null) return instance;
        Class<XMLSecureFactoriesCache> clazz = XMLSecureFactoriesCache.class;
        synchronized (XMLSecureFactoriesCache.class) {
            if (instance != null) return instance;
            instance = new XMLSecureFactoriesCache();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private XMLSecureFactoriesCache() {
    }

    public DocumentBuilderFactory getDocumentBuilderFactory(final DefaultXMLSecureFactories secureFactories) {
        XMLFactoryConfig config = new XMLFactoryConfig(secureFactories, null, DocumentBuilderFactory.class.toString()){

            @Override
            public Object createFactory() {
                return secureFactories.createDocumentBuilderFactory();
            }
        };
        return (DocumentBuilderFactory)this.cache.getUnchecked(config);
    }

    public SAXParserFactory getSAXParserFactory(final DefaultXMLSecureFactories secureFactories) {
        XMLFactoryConfig config = new XMLFactoryConfig(secureFactories, null, SAXParserFactory.class.toString()){

            @Override
            public Object createFactory() {
                return secureFactories.createSaxParserFactory();
            }
        };
        return (SAXParserFactory)this.cache.getUnchecked(config);
    }

    public XMLInputFactory getXMLInputFactory(final DefaultXMLSecureFactories secureFactories) {
        XMLFactoryConfig config = new XMLFactoryConfig(secureFactories, null, XMLInputFactory.class.toString()){

            @Override
            public Object createFactory() {
                return secureFactories.createXMLInputFactory();
            }
        };
        return (XMLInputFactory)this.cache.getUnchecked(config);
    }

    public TransformerFactory getTransformerFactory(final DefaultXMLSecureFactories secureFactories) {
        XMLFactoryConfig config = new XMLFactoryConfig(secureFactories, null, TransformerFactory.class.toString()){

            @Override
            public Object createFactory() {
                return secureFactories.createTransformerFactory();
            }
        };
        return (TransformerFactory)this.cache.getUnchecked(config);
    }

    public SchemaFactory getSchemaFactory(final DefaultXMLSecureFactories secureFactories, String schemaLanguage) {
        XMLFactoryConfig config = new XMLFactoryConfig(secureFactories, schemaLanguage, SchemaFactory.class.toString()){

            @Override
            public Object createFactory() {
                return secureFactories.createSchemaFactory(this.schemaLanguage);
            }
        };
        return (SchemaFactory)this.cache.getUnchecked(config);
    }
}

