/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.embedded.internal.classloading;

import com.google.common.base.Preconditions;
import java.util.Arrays;
import java.util.Set;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

public class ClassLoaderFilter {
    private static final String EMPTY_PACKAGE = "";
    private static final char RESOURCE_SEPARATOR = '/';
    public static final String CLASS_PACKAGE_SPLIT_REGEX = "\\.";
    public static final String RESOURCE_PACKAGE_SPLIT_REGEX = "/";
    private final Set<String> bootPackages;
    private Set<String> exportedResources;

    public ClassLoaderFilter(Set<String> bootPackages, Set<String> exportedResources) {
        this.bootPackages = bootPackages;
        this.exportedResources = exportedResources;
    }

    public boolean exportsClass(String name) {
        return this.isExportedBootPackage(name, CLASS_PACKAGE_SPLIT_REGEX);
    }

    public boolean exportsResource(String name) {
        Preconditions.checkArgument(name != null, "Resource name cannot be null");
        String sanitizeResourceName = this.sanitizeResourceName(name);
        return this.exportedResources.contains(sanitizeResourceName);
    }

    private String sanitizeResourceName(String resourceName) {
        String sanitizedResource = EMPTY_PACKAGE;
        if (resourceName.length() > 0) {
            String string = sanitizedResource = resourceName.charAt(0) == '/' ? resourceName.substring(1) : resourceName;
            if (sanitizedResource.length() > 0) {
                sanitizedResource = sanitizedResource.charAt(sanitizedResource.length() - 1) == '/' ? sanitizedResource.substring(0, sanitizedResource.length() - 1) : sanitizedResource;
            }
        }
        return sanitizedResource;
    }

    private boolean isExportedBootPackage(String name, String splitRegex) {
        boolean exported = false;
        String[] splitName = name.split(splitRegex);
        String[] packages = Arrays.copyOf(splitName, splitName.length - 1);
        String candidatePackage = EMPTY_PACKAGE;
        for (String currentPackage : packages) {
            if (candidatePackage.length() != 0) {
                candidatePackage = candidatePackage + ".";
            }
            if (!this.bootPackages.contains(candidatePackage = candidatePackage + currentPackage)) continue;
            exported = true;
            break;
        }
        return exported;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString(this, ToStringStyle.MULTI_LINE_STYLE);
    }
}

