/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.embedded.internal.classloading;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.net.URL;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.mule.runtime.module.embedded.internal.NotExportedClassException;
import org.mule.runtime.module.embedded.internal.classloading.ClassLoaderFilter;
import org.mule.runtime.module.embedded.internal.classloading.EnumerationAdapter;
import org.mule.runtime.module.embedded.internal.classloading.ExportedService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FilteringClassLoader
extends ClassLoader {
    private static final String SERVICE_PREFIX = "META-INF/services/";
    protected static final Logger logger = LoggerFactory.getLogger(FilteringClassLoader.class);
    public static final String SYSTEM_PROPERTY_PREFIX = "mule.";
    public static final String MULE_LOG_VERBOSE_CLASSLOADING = "mule.classloading.verbose";
    private final ClassLoaderFilter filter;
    private final List<ExportedService> exportedServices;

    public FilteringClassLoader(ClassLoader parent, ClassLoaderFilter filter, List<ExportedService> exportedServices) {
        super(parent);
        Preconditions.checkArgument(filter != null, "Filter cannot be null");
        Preconditions.checkArgument(exportedServices != null, "exportedServices cannot be null");
        this.filter = filter;
        this.exportedServices = exportedServices;
    }

    @Override
    public Class<?> loadClass(String name) throws ClassNotFoundException {
        if (this.filter.exportsClass(name)) {
            return super.loadClass(name);
        }
        throw new NotExportedClassException(name, this.filter);
    }

    @Override
    protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        if (this.filter.exportsClass(name)) {
            return super.loadClass(name, resolve);
        }
        throw new NotExportedClassException(name, this.filter);
    }

    @Override
    public URL getResource(String name) {
        if (this.isServiceResource(name)) {
            Optional<ExportedService> exportedService = this.getExportedServiceStream(name).findFirst();
            if (exportedService.isPresent()) {
                this.logClassloadingTrace(String.format("Service resource '%s' found: '%s", name, exportedService.get()));
                return exportedService.get().getResource();
            }
            this.logClassloadingTrace(String.format("Service resource '%s' not found", name));
            return null;
        }
        if (this.filter.exportsResource(name)) {
            return super.getResource(name);
        }
        this.logClassloadingTrace(String.format("Resource '%s' not found in classloader.", name));
        this.logClassloadingTrace(String.format("Filter applied for resource: %s", name));
        return null;
    }

    @Override
    public Enumeration<URL> getResources(String name) throws IOException {
        if (this.isServiceResource(name)) {
            List exportedServiceProviders = this.getExportedServiceStream(name).map(s2 -> s2.getResource()).collect(Collectors.toList());
            if (exportedServiceProviders.isEmpty()) {
                this.logClassloadingTrace(String.format("Service resource '%s' not found", name));
            } else {
                this.logClassloadingTrace(String.format("Service resources '%s' found: '%s", name, exportedServiceProviders));
            }
            return new EnumerationAdapter<URL>(exportedServiceProviders);
        }
        if (this.filter.exportsResource(name)) {
            return this.getResourcesFromDelegate(name);
        }
        this.logClassloadingTrace(String.format("Resources '%s' not found ", name));
        this.logClassloadingTrace(String.format("Filter applied for resources: '%s", name));
        return new EnumerationAdapter<URL>(Collections.emptyList());
    }

    private Stream<ExportedService> getExportedServiceStream(String name) {
        String serviceInterface = this.getServiceInterfaceFromResource(name);
        return this.exportedServices.stream().filter(s2 -> serviceInterface.equals(s2.getServiceInterface()));
    }

    private String getServiceInterfaceFromResource(String name) {
        return name.substring(SERVICE_PREFIX.length());
    }

    private boolean isServiceResource(String name) {
        return name.startsWith(SERVICE_PREFIX);
    }

    private void logClassloadingTrace(String message) {
        if (this.isVerboseClassLoading().booleanValue()) {
            logger.info(message);
        } else if (logger.isTraceEnabled()) {
            logger.trace(message);
        }
    }

    private Boolean isVerboseClassLoading() {
        return Boolean.valueOf(System.getProperty(MULE_LOG_VERBOSE_CLASSLOADING));
    }

    protected Enumeration<URL> getResourcesFromDelegate(String name) throws IOException {
        return this.findResources(name);
    }
}

