/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.api.classloader.model;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.mule.tools.api.classloader.model.Artifact;
import org.mule.tools.api.classloader.model.ArtifactCoordinates;

public class ClassLoaderModel {
    private String version;
    private ArtifactCoordinates artifactCoordinates;
    private List<Artifact> dependencies = new ArrayList<Artifact>();
    private String[] packages;
    private String[] resources;

    public ClassLoaderModel(String version, ArtifactCoordinates artifactCoordinates) {
        this.setArtifactCoordinates(artifactCoordinates);
        this.setVersion(version);
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        Preconditions.checkArgument(version != null, "Version cannot be null");
        this.version = version;
    }

    public ArtifactCoordinates getArtifactCoordinates() {
        return this.artifactCoordinates;
    }

    public void setArtifactCoordinates(ArtifactCoordinates artifactCoordinates) {
        Preconditions.checkArgument(artifactCoordinates != null, "Artifact coordinates cannot be null");
        this.artifactCoordinates = artifactCoordinates;
    }

    public List<Artifact> getDependencies() {
        return this.dependencies;
    }

    public void setDependencies(List<Artifact> dependencies) {
        this.dependencies = dependencies;
    }

    public Set<Artifact> getArtifacts() {
        TreeSet<Artifact> allDependencies = new TreeSet<Artifact>();
        allDependencies.addAll(this.dependencies);
        return allDependencies.stream().collect(Collectors.toSet());
    }

    public ClassLoaderModel getParametrizedUriModel() {
        ClassLoaderModel copy = this.doGetParameterizedUriModel();
        List<Artifact> dependenciesCopy = this.dependencies.stream().map(Artifact::copyWithParameterizedUri).collect(Collectors.toList());
        copy.setDependencies(dependenciesCopy);
        copy.setPackages(this.getPackages());
        copy.setResources(this.getResources());
        return copy;
    }

    protected ClassLoaderModel doGetParameterizedUriModel() {
        ClassLoaderModel copy = new ClassLoaderModel(this.version, this.artifactCoordinates);
        return copy;
    }

    public String[] getPackages() {
        return this.packages;
    }

    public void setPackages(String[] packages) {
        this.packages = packages;
    }

    public String[] getResources() {
        return this.resources;
    }

    public void setResources(String[] resources) {
        this.resources = resources;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !(o instanceof ClassLoaderModel)) {
            return false;
        }
        ClassLoaderModel that = (ClassLoaderModel)o;
        return this.getArtifactCoordinates().equals(that.getArtifactCoordinates());
    }

    public int hashCode() {
        return this.getArtifactCoordinates().hashCode();
    }
}

