/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.api.classloader.model.resolver;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.mule.maven.client.api.MavenClient;
import org.mule.maven.pom.parser.api.model.BundleDependency;
import org.mule.maven.pom.parser.api.model.BundleDescriptor;
import org.mule.tools.api.classloader.model.resolver.ClassloaderModelResolver;
import org.mule.tools.api.validation.VersionUtils;

public class MulePluginClassloaderModelResolver
extends ClassloaderModelResolver {
    public MulePluginClassloaderModelResolver(MavenClient mavenClient) {
        super(mavenClient, "mule-plugin");
    }

    @Override
    protected List<BundleDependency> resolveConflicts(List<BundleDependency> newDependencies, List<BundleDependency> alreadyResolved) {
        return this.resolveMulePluginsVersions(newDependencies, alreadyResolved);
    }

    @Override
    public Map<BundleDependency, List<BundleDependency>> resolveDependencies(List<BundleDependency> mulePlugins) {
        LinkedHashMap<BundleDependency, List<BundleDependency>> muleDependenciesDependencies = new LinkedHashMap<BundleDependency, List<BundleDependency>>();
        for (BundleDependency muleDependency : mulePlugins) {
            muleDependenciesDependencies.put(muleDependency, this.collectTransitiveDependencies(muleDependency));
        }
        return muleDependenciesDependencies;
    }

    private List<BundleDependency> collectTransitiveDependencies(BundleDependency rootDependency) {
        LinkedList<BundleDependency> allTransitiveDependencies = new LinkedList<BundleDependency>();
        for (BundleDependency transitiveDependency : rootDependency.getTransitiveDependencies()) {
            allTransitiveDependencies.add(transitiveDependency);
            if (!transitiveDependency.getDescriptor().getClassifier().map(c -> !"mule-plugin".equals(c)).orElse(true).booleanValue()) continue;
            allTransitiveDependencies.addAll(this.collectTransitiveDependencies(transitiveDependency));
        }
        return allTransitiveDependencies;
    }

    protected List<BundleDependency> resolveMulePluginsVersions(List<BundleDependency> mulePluginsToResolve, List<BundleDependency> definitiveMulePlugins) {
        ArrayList<BundleDependency> resolvedPlugins = new ArrayList<BundleDependency>();
        Preconditions.checkArgument(mulePluginsToResolve != null, "List of mule plugins to resolve should not be null");
        Preconditions.checkArgument(definitiveMulePlugins != null, "List of definitive mule plugins should not be null");
        for (BundleDependency mulePluginToResolve : mulePluginsToResolve) {
            Optional<BundleDependency> mulePlugin = definitiveMulePlugins.stream().filter(p -> this.hasSameArtifactIdAndMajor((BundleDependency)p, mulePluginToResolve)).findFirst();
            resolvedPlugins.add(mulePlugin.orElse(mulePluginToResolve));
        }
        return resolvedPlugins;
    }

    protected boolean hasSameArtifactIdAndMajor(BundleDependency bundleDependency, BundleDependency otherBundleDependency) {
        BundleDescriptor descriptor = bundleDependency.getDescriptor();
        BundleDescriptor otherDescriptor = otherBundleDependency.getDescriptor();
        return StringUtils.equals(descriptor.getArtifactId(), otherDescriptor.getArtifactId()) && StringUtils.equals(VersionUtils.getMajor(descriptor.getBaseVersion()), VersionUtils.getMajor(otherDescriptor.getBaseVersion()));
    }
}

