/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.api.packager;

import com.google.common.base.Preconditions;
import java.io.File;
import java.nio.file.Path;
import org.apache.commons.lang3.StringUtils;
import org.mule.tools.api.packager.packaging.PackagingType;

public abstract class AbstractProjectFoldersGenerator {
    private String groupId;
    private String artifactId;
    private PackagingType packagingType;

    public AbstractProjectFoldersGenerator(String groupId, String artifactId, PackagingType packagingType) {
        Preconditions.checkArgument(StringUtils.isNotEmpty(groupId), "The groupId must not be null nor empty");
        Preconditions.checkArgument(StringUtils.isNotEmpty(artifactId), "The artifactId must not be null nor empty");
        Preconditions.checkArgument(packagingType != null, "The packagingType must not be null");
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.packagingType = packagingType;
    }

    protected String getGroupId() {
        return this.groupId;
    }

    protected String getArtifactId() {
        return this.artifactId;
    }

    public PackagingType getPackagingType() {
        return this.packagingType;
    }

    public abstract void generate(Path var1);

    protected void createFolderIfNecessary(String ... folderPath) {
        String path = StringUtils.join((Object[])folderPath, File.separator);
        File folder = new File(path);
        if (!folder.exists()) {
            folder.mkdirs();
        }
    }
}

