/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.api.util.exclude;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.util.Collection;
import java.util.List;
import org.mule.tools.api.util.exclude.GlobMatcher;
import org.mule.tools.api.util.exclude.GlobMatcherFileReader;

public class MuleExclusionMatcher
implements PathMatcher {
    protected static final String MULE_EXCLUDE_FILENAME = "_muleExclude";
    public static final GlobMatcher CLASSPATH_FILE_MATCHER = new GlobMatcher(".classpath");
    public static final GlobMatcher PROJECT_FILE_MATCHER = new GlobMatcher(".project");
    private List<GlobMatcher> muleExcludeMatchers = Lists.newArrayList(CLASSPATH_FILE_MATCHER, PROJECT_FILE_MATCHER);

    public MuleExclusionMatcher() {
    }

    public MuleExclusionMatcher(Path projectBaseFolder) throws IOException {
        Preconditions.checkArgument(projectBaseFolder != null, "Project base folder should not be null");
        this.parse(new File(projectBaseFolder.toFile(), MULE_EXCLUDE_FILENAME));
    }

    private void parse(File file) throws IOException {
        if (file.exists()) {
            this.muleExcludeMatchers.addAll((Collection<GlobMatcher>)Files.readLines(file, Charset.defaultCharset(), new GlobMatcherFileReader()));
        }
    }

    @Override
    public boolean matches(Path file) {
        return this.muleExcludeMatchers.stream().anyMatch(pattern -> pattern.matches(file));
    }
}

