/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.api.validation.deployment;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.List;
import org.mule.tools.api.exception.ValidationException;
import org.mule.tools.api.packager.ProjectInformation;
import org.mule.tools.api.packager.packaging.Classifier;
import org.mule.tools.api.validation.project.AbstractProjectValidator;

public class ProjectDeploymentValidator {
    private static final List<String> NON_DEPLOYABLE_ARTIFACTS = Lists.newArrayList(Classifier.MULE_POLICY.toString(), Classifier.MULE_DOMAIN_BUNDLE.toString(), Classifier.MULE_APPLICATION_TEMPLATE.toString());
    private ProjectInformation projectInformation;

    public ProjectDeploymentValidator(ProjectInformation projectInformation) {
        Preconditions.checkArgument(projectInformation != null, "The project information must not be null");
        this.projectInformation = projectInformation;
    }

    public ProjectInformation getDefaultProjectInformation() {
        return this.projectInformation;
    }

    public void isDeployable() throws ValidationException {
        if (this.projectInformation.isDeployment()) {
            this.validateIsDeployable();
        }
    }

    private void validateIsDeployable() throws ValidationException {
        String artifactType = this.getArtifactType();
        for (String nonDeployableType : NON_DEPLOYABLE_ARTIFACTS) {
            if (!artifactType.contains(nonDeployableType)) continue;
            throw new ValidationException("Deployment of " + nonDeployableType + " projects is not supported");
        }
        AbstractProjectValidator.isClassifierValid(artifactType);
    }

    private String getArtifactType() {
        return this.projectInformation.getClassifier();
    }
}

