/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.client;

import com.google.common.base.Preconditions;
import java.util.concurrent.TimeoutException;

public class OperationRetrier {
    private static final Integer DEFAULT_ATTEMPTS = 10;
    private static final Long DEFAULT_SLEEP_TIME = 30000L;
    private Long sleepTime;
    private Integer attempts;

    public Long getSleepTime() {
        return this.sleepTime == null ? DEFAULT_SLEEP_TIME : this.sleepTime;
    }

    public void setSleepTime(Long sleepTime) {
        Preconditions.checkArgument(sleepTime != null, "Sleep cannot be null");
        Preconditions.checkArgument(sleepTime > 0L, "Sleep time should be positive");
        this.sleepTime = sleepTime;
    }

    public Integer getAttempts() {
        return this.attempts == null ? DEFAULT_ATTEMPTS : this.attempts;
    }

    public void setAttempts(Integer attempts) {
        Preconditions.checkArgument(attempts != null, "Attempts cannot be null");
        Preconditions.checkArgument(attempts > 0, "Attempts should be positive");
        this.attempts = attempts;
    }

    public void setTimeout(Long timeout) {
        this.setSleepTime(timeout == null ? this.getSleepTime() : timeout / (long)this.getAttempts().intValue());
    }

    public void retry(RetriableOperation operation) throws InterruptedException, TimeoutException {
        int i;
        boolean keepRunning = true;
        for (i = 0; i < this.getAttempts() && keepRunning; ++i) {
            keepRunning = operation.run();
            if (!keepRunning) continue;
            Thread.sleep(this.getSleepTime());
        }
        if (i == this.getAttempts() && keepRunning) {
            throw new TimeoutException("Maximum number of attempts [" + this.getAttempts() + "] has been exceeded. " + operation.getRetryExhaustedMessage());
        }
    }

    public static interface RetriableOperation {
        public Boolean run();

        default public String getRetryExhaustedMessage() {
            return "";
        }
    }
}

