/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.client.core.logging;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Type;
import java.util.Map;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.client.ClientRequestContext;
import javax.ws.rs.client.ClientRequestFilter;
import javax.ws.rs.client.ClientResponseContext;
import javax.ws.rs.client.ClientResponseFilter;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.WriterInterceptor;
import javax.ws.rs.ext.WriterInterceptorContext;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.mule.tools.client.core.logging.RequestLoggingStream;
import org.mule.tools.utils.DeployerLog;

public class ClientLoggingFilter
implements ClientRequestFilter,
ClientResponseFilter,
WriterInterceptor {
    public static final String CLIENT_LOGGING_LOG_MULTIPART = "client.logging.log.multipart";
    private static final String REQUEST_LOGGING_STREAM = "requestLoggingStream";
    private final DeployerLog log;

    public ClientLoggingFilter(DeployerLog log) {
        this.log = log;
    }

    @Override
    public void filter(ClientRequestContext context) {
        StringBuilder request = new StringBuilder();
        request.append("HTTP Request").append(String.format("%n", new Object[0])).append(context.getMethod()).append(" ").append(context.getUri()).append(String.format("%n", new Object[0]));
        this.appendHeaders(request, context.getStringHeaders());
        if (context.hasEntity() && this.shouldLogEntity(context.getEntityType())) {
            RequestLoggingStream stream = new RequestLoggingStream(request, context.getEntityStream());
            context.setEntityStream(stream);
            context.setProperty(REQUEST_LOGGING_STREAM, stream);
            return;
        }
        this.log.debug(request.toString());
    }

    @Override
    public void filter(ClientRequestContext requestContext, ClientResponseContext responseContext) throws IOException {
        StringBuilder response = new StringBuilder();
        response.append("HTTP response").append(String.format("%n", new Object[0])).append(responseContext.getStatus()).append(" ").append(responseContext.getStatusInfo().getReasonPhrase()).append(String.format("%n", new Object[0]));
        this.appendHeaders(response, responseContext.getHeaders());
        if (responseContext.hasEntity()) {
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            IOUtils.copy(responseContext.getEntityStream(), (OutputStream)stream);
            byte[] responseBytes = stream.toByteArray();
            response.append(new String(responseBytes)).append(String.format("%n", new Object[0]));
            responseContext.setEntityStream(new ByteArrayInputStream(responseBytes));
        }
        this.log.debug(response.toString());
    }

    @Override
    public void aroundWriteTo(WriterInterceptorContext writerInterceptorContext) throws IOException, WebApplicationException {
        RequestLoggingStream stream = (RequestLoggingStream)writerInterceptorContext.getProperty(REQUEST_LOGGING_STREAM);
        writerInterceptorContext.proceed();
        if (stream != null) {
            this.log.debug(stream.getRequestLog());
        }
    }

    private void appendHeaders(StringBuilder builder, MultivaluedMap<String, String> headers) {
        for (Map.Entry headerEntry : headers.entrySet()) {
            builder.append((String)headerEntry.getKey()).append(": ").append(StringUtils.join((Iterable)headerEntry.getValue(), ", ")).append(String.format("%n", new Object[0]));
        }
        builder.append(String.format("%n", new Object[0]));
    }

    private boolean shouldLogEntity(Type entityType) {
        if (!entityType.getTypeName().contains("FormDataMultiPart")) {
            return true;
        }
        return entityType.getTypeName().contains("FormDataMultiPart") && this.shouldLogMultiPart() != false;
    }

    private Boolean shouldLogMultiPart() {
        return Boolean.getBoolean(CLIENT_LOGGING_LOG_MULTIPART);
    }
}

