/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.archiver;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.UndeclaredThrowableException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.attribute.FileTime;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import javax.inject.Provider;
import org.codehaus.plexus.archiver.ArchiveEntry;
import org.codehaus.plexus.archiver.ArchiveFinalizer;
import org.codehaus.plexus.archiver.ArchivedFileSet;
import org.codehaus.plexus.archiver.Archiver;
import org.codehaus.plexus.archiver.ArchiverException;
import org.codehaus.plexus.archiver.DotDirectiveArchiveFinalizer;
import org.codehaus.plexus.archiver.FileSet;
import org.codehaus.plexus.archiver.FinalizerEnabled;
import org.codehaus.plexus.archiver.ResourceIterator;
import org.codehaus.plexus.archiver.manager.ArchiverManager;
import org.codehaus.plexus.archiver.manager.NoSuchArchiverException;
import org.codehaus.plexus.archiver.util.DefaultArchivedFileSet;
import org.codehaus.plexus.archiver.util.DefaultFileSet;
import org.codehaus.plexus.components.io.attributes.PlexusIoResourceAttributeUtils;
import org.codehaus.plexus.components.io.attributes.PlexusIoResourceAttributes;
import org.codehaus.plexus.components.io.attributes.SimpleResourceAttributes;
import org.codehaus.plexus.components.io.functions.ResourceAttributeSupplier;
import org.codehaus.plexus.components.io.resources.AbstractPlexusIoResourceCollection;
import org.codehaus.plexus.components.io.resources.EncodingSupported;
import org.codehaus.plexus.components.io.resources.PlexusIoArchivedResourceCollection;
import org.codehaus.plexus.components.io.resources.PlexusIoFileResourceCollection;
import org.codehaus.plexus.components.io.resources.PlexusIoResource;
import org.codehaus.plexus.components.io.resources.PlexusIoResourceCollection;
import org.codehaus.plexus.components.io.resources.proxy.PlexusIoProxyResourceCollection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractArchiver
implements Archiver,
FinalizerEnabled {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private File destFile;
    private final List<Object> resources = new ArrayList<Object>();
    private boolean includeEmptyDirs = true;
    private int forcedFileMode = -1;
    private int forcedDirectoryMode = -1;
    private int defaultFileMode = -1;
    private int defaultDirectoryMode = -1;
    private int umask = -1;
    private boolean forced = true;
    private List<ArchiveFinalizer> finalizers;
    private File dotFileDirectory;
    private String duplicateBehavior = "skip";
    private final boolean replacePathSlashesToJavaPaths = File.separatorChar == '/';
    private final List<Closeable> closeables = new ArrayList<Closeable>();
    private boolean useJvmChmod = true;
    private FileTime lastModifiedTime;
    private Comparator<String> filenameComparator;
    private int overrideUid = -1;
    private String overrideUserName;
    private int overrideGid = -1;
    private String overrideGroupName;
    @Inject
    private Provider<ArchiverManager> archiverManagerProvider;
    private boolean ignorePermissions = false;

    protected Logger getLogger() {
        return this.logger;
    }

    @Override
    public String getDuplicateBehavior() {
        return this.duplicateBehavior;
    }

    @Override
    public void setDuplicateBehavior(String duplicate) {
        if (!Archiver.DUPLICATES_VALID_BEHAVIORS.contains(duplicate)) {
            throw new IllegalArgumentException("Invalid duplicate-file behavior: '" + duplicate + "'. Please specify one of: " + Archiver.DUPLICATES_VALID_BEHAVIORS);
        }
        this.duplicateBehavior = duplicate;
    }

    @Override
    public final void setFileMode(int mode) {
        this.forcedFileMode = mode >= 0 ? mode & 0xFFF | 0x8000 : -1;
    }

    @Override
    public final void setDefaultFileMode(int mode) {
        this.defaultFileMode = mode & 0xFFF | 0x8000;
    }

    @Override
    public final int getOverrideFileMode() {
        return this.forcedFileMode;
    }

    @Override
    public final int getFileMode() {
        if (this.forcedFileMode < 0) {
            if (this.defaultFileMode < 0) {
                return 33188;
            }
            return this.defaultFileMode;
        }
        return this.forcedFileMode;
    }

    @Override
    public final int getDefaultFileMode() {
        return this.defaultFileMode;
    }

    @Deprecated
    public final int getRawDefaultFileMode() {
        return this.getDefaultFileMode();
    }

    @Override
    public final void setDirectoryMode(int mode) {
        this.forcedDirectoryMode = mode >= 0 ? mode & 0xFFF | 0x4000 : -1;
    }

    @Override
    public final void setDefaultDirectoryMode(int mode) {
        this.defaultDirectoryMode = mode & 0xFFF | 0x4000;
    }

    @Override
    public final int getOverrideDirectoryMode() {
        return this.forcedDirectoryMode;
    }

    @Override
    public final int getDirectoryMode() {
        if (this.forcedDirectoryMode < 0) {
            if (this.defaultDirectoryMode < 0) {
                return 16877;
            }
            return this.defaultDirectoryMode;
        }
        return this.forcedDirectoryMode;
    }

    @Override
    public final int getDefaultDirectoryMode() {
        if (this.defaultDirectoryMode < 0) {
            return 16877;
        }
        return this.defaultDirectoryMode;
    }

    @Override
    public boolean getIncludeEmptyDirs() {
        return this.includeEmptyDirs;
    }

    @Override
    public void setIncludeEmptyDirs(boolean includeEmptyDirs) {
        this.includeEmptyDirs = includeEmptyDirs;
    }

    @Override
    public void addDirectory(@Nonnull File directory) throws ArchiverException {
        this.addFileSet((FileSet)((DefaultFileSet)((DefaultFileSet)DefaultFileSet.fileSet(directory).prefixed("")).includeExclude(null, null)).includeEmptyDirs(this.includeEmptyDirs));
    }

    @Override
    public void addDirectory(@Nonnull File directory, String prefix) throws ArchiverException {
        this.addFileSet((FileSet)((DefaultFileSet)((DefaultFileSet)DefaultFileSet.fileSet(directory).prefixed(prefix)).includeExclude(null, null)).includeEmptyDirs(this.includeEmptyDirs));
    }

    @Override
    public void addDirectory(@Nonnull File directory, String[] includes, String[] excludes) throws ArchiverException {
        this.addFileSet((FileSet)((DefaultFileSet)((DefaultFileSet)DefaultFileSet.fileSet(directory).prefixed("")).includeExclude(includes, excludes)).includeEmptyDirs(this.includeEmptyDirs));
    }

    @Override
    public void addDirectory(@Nonnull File directory, String prefix, String[] includes, String[] excludes) throws ArchiverException {
        this.addFileSet((FileSet)((DefaultFileSet)((DefaultFileSet)DefaultFileSet.fileSet(directory).prefixed(prefix)).includeExclude(includes, excludes)).includeEmptyDirs(this.includeEmptyDirs));
    }

    @Override
    public void addFileSet(@Nonnull FileSet fileSet) throws ArchiverException {
        File directory = fileSet.getDirectory();
        if (directory == null) {
            throw new ArchiverException("The file sets base directory is null.");
        }
        if (!directory.isDirectory()) {
            throw new ArchiverException(directory.getAbsolutePath() + " isn't a directory.");
        }
        PlexusIoFileResourceCollection collection = new PlexusIoFileResourceCollection();
        collection.setFollowingSymLinks(false);
        collection.setIncludes(fileSet.getIncludes());
        collection.setExcludes(fileSet.getExcludes());
        collection.setBaseDir(directory);
        collection.setFileSelectors(fileSet.getFileSelectors());
        collection.setIncludingEmptyDirectories(fileSet.isIncludingEmptyDirectories());
        collection.setPrefix(fileSet.getPrefix());
        collection.setCaseSensitive(fileSet.isCaseSensitive());
        collection.setUsingDefaultExcludes(fileSet.isUsingDefaultExcludes());
        collection.setStreamTransformer(fileSet.getStreamTransformer());
        collection.setFileMappers(fileSet.getFileMappers());
        collection.setFilenameComparator(this.getFilenameComparator());
        if (this.getOverrideDirectoryMode() > -1 || this.getOverrideFileMode() > -1 || this.getOverrideUid() > -1 || this.getOverrideGid() > -1 || this.getOverrideUserName() != null || this.getOverrideGroupName() != null) {
            collection.setOverrideAttributes(this.getOverrideUid(), this.getOverrideUserName(), this.getOverrideGid(), this.getOverrideGroupName(), this.getOverrideFileMode(), this.getOverrideDirectoryMode());
        }
        if (this.getDefaultDirectoryMode() > -1 || this.getDefaultFileMode() > -1) {
            collection.setDefaultAttributes(-1, null, -1, null, this.getDefaultFileMode(), this.getDefaultDirectoryMode());
        }
        this.addResources(collection);
    }

    @Override
    public void addFile(@Nonnull File inputFile, @Nonnull String destFileName) throws ArchiverException {
        int permissions;
        if (this.forcedFileMode > 0) {
            permissions = this.forcedFileMode;
        } else {
            permissions = -1;
            try {
                permissions = PlexusIoResourceAttributeUtils.getFileAttributes(inputFile).getOctalMode();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.addFile(inputFile, destFileName, permissions);
    }

    @Override
    public void addSymlink(String symlinkName, String symlinkDestination) throws ArchiverException {
        int fileMode = this.getOverrideFileMode();
        this.addSymlink(symlinkName, fileMode, symlinkDestination);
    }

    @Override
    public void addSymlink(String symlinkName, int permissions, String symlinkDestination) throws ArchiverException {
        this.doAddResource(ArchiveEntry.createSymlinkEntry(symlinkName, permissions, symlinkDestination, this.getDirectoryMode()));
    }

    private ArchiveEntry updateArchiveEntryAttributes(ArchiveEntry entry) {
        if (this.getOverrideUid() > -1 || this.getOverrideGid() > -1 || this.getOverrideUserName() != null || this.getOverrideGroupName() != null) {
            entry.setResourceAttributes(new SimpleResourceAttributes(this.getOverrideUid(), this.getOverrideUserName(), this.getOverrideGid(), this.getOverrideGroupName(), entry.getMode()));
        }
        return entry;
    }

    protected ArchiveEntry asArchiveEntry(@Nonnull PlexusIoResource resource, String destFileName, int permissions, PlexusIoResourceCollection collection) throws ArchiverException {
        if (!resource.isExisting()) {
            throw new ArchiverException(resource.getName() + " not found.");
        }
        if (this.umask > 0 && permissions != -1) {
            permissions &= ~this.umask;
        }
        ArchiveEntry entry = resource.isFile() ? ArchiveEntry.createFileEntry(destFileName, resource, permissions, collection, this.getDirectoryMode()) : ArchiveEntry.createDirectoryEntry(destFileName, resource, permissions, this.getDirectoryMode());
        return this.updateArchiveEntryAttributes(entry);
    }

    private ArchiveEntry asArchiveEntry(AddedResourceCollection collection, PlexusIoResource resource) throws ArchiverException {
        PlexusIoResourceAttributes attrs;
        String destFileName = collection.resources.getName(resource);
        int fromResource = -1;
        if (resource instanceof ResourceAttributeSupplier && (attrs = ((ResourceAttributeSupplier)((Object)resource)).getAttributes()) != null) {
            fromResource = attrs.getOctalMode();
        }
        return this.asArchiveEntry(resource, destFileName, collection.maybeOverridden(fromResource, resource.isDirectory()), collection.resources);
    }

    @Override
    public void addResource(PlexusIoResource resource, String destFileName, int permissions) throws ArchiverException {
        this.doAddResource(this.asArchiveEntry(resource, destFileName, permissions, null));
    }

    @Override
    public void addFile(@Nonnull File inputFile, @Nonnull String destFileName, int permissions) throws ArchiverException {
        if (!inputFile.isFile() || !inputFile.exists()) {
            throw new ArchiverException(inputFile.getAbsolutePath() + " isn't a file.");
        }
        if (this.replacePathSlashesToJavaPaths) {
            destFileName = destFileName.replace('\\', '/');
        }
        if (permissions < 0) {
            permissions = this.getOverrideFileMode();
        }
        if (this.umask > 0 && permissions != -1) {
            permissions &= ~this.umask;
        }
        try {
            ArchiveEntry entry = ArchiveEntry.createFileEntry(destFileName, inputFile, permissions, this.getDirectoryMode());
            this.doAddResource(this.updateArchiveEntryAttributes(entry));
        }
        catch (IOException e) {
            throw new ArchiverException("Failed to determine inclusion status for: " + inputFile, e);
        }
    }

    @Override
    @Nonnull
    public ResourceIterator getResources() throws ArchiverException {
        return new ResourceIterator(){
            private final Iterator<Object> addedResourceIter;
            private AddedResourceCollection currentResourceCollection;
            private Iterator ioResourceIter;
            private ArchiveEntry nextEntry;
            private final Set<String> seenEntries;
            {
                this.addedResourceIter = AbstractArchiver.this.resources.iterator();
                this.seenEntries = new HashSet<String>();
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public boolean hasNext() {
                do {
                    if (this.nextEntry == null) {
                        if (this.ioResourceIter == null) {
                            if (this.addedResourceIter.hasNext()) {
                                Object o = this.addedResourceIter.next();
                                if (o instanceof ArchiveEntry) {
                                    this.nextEntry = (ArchiveEntry)o;
                                } else {
                                    if (!(o instanceof AddedResourceCollection)) return this.throwIllegalResourceType(o);
                                    this.currentResourceCollection = (AddedResourceCollection)o;
                                    try {
                                        this.ioResourceIter = this.currentResourceCollection.resources.getResources();
                                    }
                                    catch (IOException e) {
                                        throw new ArchiverException(e.getMessage(), e);
                                    }
                                }
                            } else {
                                this.nextEntry = null;
                            }
                        } else if (this.ioResourceIter.hasNext()) {
                            PlexusIoResource resource = (PlexusIoResource)this.ioResourceIter.next();
                            this.nextEntry = AbstractArchiver.this.asArchiveEntry(this.currentResourceCollection, resource);
                        } else {
                            AbstractArchiver.this.addCloseable(this.ioResourceIter);
                            this.ioResourceIter = null;
                        }
                    }
                    if (this.nextEntry == null || !this.seenEntries.contains(this.normalizedForDuplicateCheck(this.nextEntry))) continue;
                    String path = this.nextEntry.getName();
                    if ("preserve".equals(AbstractArchiver.this.duplicateBehavior) || "skip".equals(AbstractArchiver.this.duplicateBehavior)) {
                        if (this.nextEntry.getType() == 1) {
                            AbstractArchiver.this.getLogger().debug(path + " already added, skipping");
                        }
                        this.nextEntry = null;
                        continue;
                    }
                    if ("fail".equals(AbstractArchiver.this.duplicateBehavior)) {
                        throw new ArchiverException("Duplicate file " + path + " was found and the duplicate attribute is 'fail'.");
                    }
                    AbstractArchiver.this.getLogger().debug("duplicate file " + path + " found, adding.");
                } while (this.nextEntry == null && (this.ioResourceIter != null || this.addedResourceIter.hasNext()));
                if (this.nextEntry == null) return false;
                return true;
            }

            private boolean throwIllegalResourceType(Object o) {
                throw new IllegalStateException("An invalid resource of type: " + o.getClass().getName() + " was added to archiver: " + this.getClass().getName());
            }

            @Override
            public ArchiveEntry next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                ArchiveEntry next = this.nextEntry;
                this.nextEntry = null;
                this.seenEntries.add(this.normalizedForDuplicateCheck(next));
                return next;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Does not support iterator");
            }

            private String normalizedForDuplicateCheck(ArchiveEntry entry) {
                return entry.getName().replace('\\', '/');
            }
        };
    }

    private static void closeIfCloseable(Object resource) throws IOException {
        if (resource == null) {
            return;
        }
        if (resource instanceof Closeable) {
            ((Closeable)resource).close();
        }
    }

    private static void closeQuietlyIfCloseable(Object resource) {
        try {
            AbstractArchiver.closeIfCloseable(resource);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Map<String, ArchiveEntry> getFiles() {
        try {
            HashMap<String, ArchiveEntry> map = new HashMap<String, ArchiveEntry>();
            ResourceIterator iter = this.getResources();
            while (iter.hasNext()) {
                ArchiveEntry entry = iter.next();
                if (!this.includeEmptyDirs && entry.getType() != 1) continue;
                map.put(entry.getName(), entry);
            }
            return map;
        }
        catch (ArchiverException e) {
            throw new UndeclaredThrowableException(e);
        }
    }

    @Override
    public File getDestFile() {
        return this.destFile;
    }

    @Override
    public void setDestFile(File destFile) {
        this.destFile = destFile;
        if (destFile != null && destFile.getParentFile() != null) {
            destFile.getParentFile().mkdirs();
        }
    }

    protected PlexusIoResourceCollection asResourceCollection(ArchivedFileSet fileSet, Charset charset) throws ArchiverException {
        PlexusIoResourceCollection resources;
        File archiveFile = fileSet.getArchive();
        try {
            resources = this.archiverManagerProvider.get().getResourceCollection(archiveFile);
        }
        catch (NoSuchArchiverException e) {
            throw new ArchiverException("Error adding archived file-set. PlexusIoResourceCollection not found for: " + archiveFile, e);
        }
        if (resources instanceof EncodingSupported) {
            ((EncodingSupported)((Object)resources)).setEncoding(charset);
        }
        if (!(resources instanceof PlexusIoArchivedResourceCollection)) {
            throw new ArchiverException("Expected " + PlexusIoArchivedResourceCollection.class.getName() + ", got " + resources.getClass().getName());
        }
        ((PlexusIoArchivedResourceCollection)resources).setFile(fileSet.getArchive());
        if (resources instanceof AbstractPlexusIoResourceCollection) {
            ((AbstractPlexusIoResourceCollection)resources).setStreamTransformer(fileSet.getStreamTransformer());
        }
        PlexusIoProxyResourceCollection proxy = new PlexusIoProxyResourceCollection(resources);
        proxy.setExcludes(fileSet.getExcludes());
        proxy.setIncludes(fileSet.getIncludes());
        proxy.setIncludingEmptyDirectories(fileSet.isIncludingEmptyDirectories());
        proxy.setCaseSensitive(fileSet.isCaseSensitive());
        proxy.setPrefix(fileSet.getPrefix());
        proxy.setUsingDefaultExcludes(fileSet.isUsingDefaultExcludes());
        proxy.setFileSelectors(fileSet.getFileSelectors());
        proxy.setStreamTransformer(fileSet.getStreamTransformer());
        proxy.setFileMappers(fileSet.getFileMappers());
        if (this.getOverrideDirectoryMode() > -1 || this.getOverrideFileMode() > -1) {
            proxy.setOverrideAttributes(-1, null, -1, null, this.getOverrideFileMode(), this.getOverrideDirectoryMode());
        }
        if (this.getDefaultDirectoryMode() > -1 || this.getDefaultFileMode() > -1) {
            proxy.setDefaultAttributes(-1, null, -1, null, this.getDefaultFileMode(), this.getDefaultDirectoryMode());
        }
        return proxy;
    }

    @Override
    public void addResources(PlexusIoResourceCollection collection) throws ArchiverException {
        this.doAddResource(new AddedResourceCollection(collection, this.forcedFileMode, this.forcedDirectoryMode));
    }

    private void doAddResource(Object item) {
        this.resources.add(item);
    }

    @Override
    public void addArchivedFileSet(ArchivedFileSet fileSet) throws ArchiverException {
        PlexusIoResourceCollection resourceCollection = this.asResourceCollection(fileSet, null);
        this.addResources(resourceCollection);
    }

    @Override
    public void addArchivedFileSet(ArchivedFileSet fileSet, Charset charset) throws ArchiverException {
        PlexusIoResourceCollection resourceCollection = this.asResourceCollection(fileSet, charset);
        this.addResources(resourceCollection);
    }

    @Override
    public void addArchivedFileSet(@Nonnull File archiveFile, String prefix, String[] includes, String[] excludes) throws ArchiverException {
        this.addArchivedFileSet((ArchivedFileSet)((DefaultArchivedFileSet)((DefaultArchivedFileSet)DefaultArchivedFileSet.archivedFileSet(archiveFile).prefixed(prefix)).includeExclude(includes, excludes)).includeEmptyDirs(this.includeEmptyDirs));
    }

    @Override
    public void addArchivedFileSet(@Nonnull File archiveFile, String prefix) throws ArchiverException {
        this.addArchivedFileSet((ArchivedFileSet)((DefaultArchivedFileSet)DefaultArchivedFileSet.archivedFileSet(archiveFile).prefixed(prefix)).includeEmptyDirs(this.includeEmptyDirs));
    }

    @Override
    public void addArchivedFileSet(@Nonnull File archiveFile, String[] includes, String[] excludes) throws ArchiverException {
        this.addArchivedFileSet((ArchivedFileSet)((DefaultArchivedFileSet)DefaultArchivedFileSet.archivedFileSet(archiveFile).includeExclude(includes, excludes)).includeEmptyDirs(this.includeEmptyDirs));
    }

    @Override
    public void addArchivedFileSet(@Nonnull File archiveFile) throws ArchiverException {
        this.addArchivedFileSet((ArchivedFileSet)DefaultArchivedFileSet.archivedFileSet(archiveFile).includeEmptyDirs(this.includeEmptyDirs));
    }

    @Override
    public boolean isForced() {
        return this.forced;
    }

    @Override
    public void setForced(boolean forced) {
        this.forced = forced;
    }

    @Override
    public void addArchiveFinalizer(ArchiveFinalizer finalizer) {
        if (this.finalizers == null) {
            this.finalizers = new ArrayList<ArchiveFinalizer>();
        }
        this.finalizers.add(finalizer);
    }

    @Override
    public void setArchiveFinalizers(List<ArchiveFinalizer> archiveFinalizers) {
        this.finalizers = archiveFinalizers;
    }

    @Override
    public void setDotFileDirectory(File dotFileDirectory) {
        this.dotFileDirectory = dotFileDirectory;
    }

    protected boolean isUptodate() throws ArchiverException {
        File zipFile = this.getDestFile();
        if (!zipFile.exists()) {
            this.getLogger().debug("isUp2date: false (Destination " + zipFile.getPath() + " not found.)");
            return false;
        }
        long destTimestamp = this.getFileLastModifiedTime(zipFile);
        Iterator<Object> it = this.resources.iterator();
        if (!it.hasNext()) {
            this.getLogger().debug("isUp2date: false (No input files.)");
            return false;
        }
        while (it.hasNext()) {
            long l;
            Object o = it.next();
            if (o instanceof ArchiveEntry) {
                l = ((ArchiveEntry)o).getResource().getLastModified();
            } else if (o instanceof AddedResourceCollection) {
                try {
                    l = ((AddedResourceCollection)o).resources.getLastModified();
                }
                catch (IOException e) {
                    throw new ArchiverException(e.getMessage(), e);
                }
            } else {
                throw new IllegalStateException("Invalid object type: " + o.getClass().getName());
            }
            if (l == 0L) {
                this.getLogger().debug("isUp2date: false (Resource with unknown modification date found.)");
                return false;
            }
            if (l <= destTimestamp) continue;
            this.getLogger().debug("isUp2date: false (Resource with newer modification date found.)");
            return false;
        }
        this.getLogger().debug("isUp2date: true");
        return true;
    }

    private long getFileLastModifiedTime(File file) throws ArchiverException {
        try {
            return Files.getLastModifiedTime(file.toPath(), new LinkOption[0]).toMillis();
        }
        catch (IOException e) {
            throw new ArchiverException(e.getMessage(), e);
        }
    }

    protected boolean checkForced() throws ArchiverException {
        if (!this.isForced() && this.isSupportingForced() && this.isUptodate()) {
            this.getLogger().debug("Archive " + this.getDestFile() + " is uptodate.");
            return false;
        }
        return true;
    }

    @Override
    public boolean isSupportingForced() {
        return false;
    }

    protected void runArchiveFinalizers() throws ArchiverException {
        if (this.finalizers != null) {
            for (ArchiveFinalizer finalizer : this.finalizers) {
                finalizer.finalizeArchiveCreation(this);
            }
        }
    }

    @Override
    public final void createArchive() throws ArchiverException, IOException {
        this.validate();
        try {
            try {
                if (this.dotFileDirectory != null) {
                    this.addArchiveFinalizer(new DotDirectiveArchiveFinalizer(this.dotFileDirectory));
                }
                this.runArchiveFinalizers();
                this.execute();
            }
            finally {
                this.close();
            }
        }
        catch (IOException e) {
            String msg = "Problem creating " + this.getArchiveType() + ": " + e.getMessage();
            StringBuffer revertBuffer = new StringBuffer();
            if (!this.revert(revertBuffer)) {
                msg = msg + revertBuffer.toString();
            }
            throw new ArchiverException(msg, e);
        }
        finally {
            this.cleanUp();
        }
        this.postCreateArchive();
    }

    protected boolean hasVirtualFiles() {
        if (this.finalizers != null) {
            for (ArchiveFinalizer finalizer : this.finalizers) {
                List virtualFiles = finalizer.getVirtualFiles();
                if (virtualFiles == null || virtualFiles.isEmpty()) continue;
                return true;
            }
        }
        return false;
    }

    protected boolean revert(StringBuffer messageBuffer) {
        return true;
    }

    protected void validate() throws ArchiverException, IOException {
    }

    protected void postCreateArchive() throws ArchiverException, IOException {
    }

    protected abstract String getArchiveType();

    private void addCloseable(Object maybeCloseable) {
        if (maybeCloseable instanceof Closeable) {
            this.closeables.add((Closeable)maybeCloseable);
        }
    }

    private void closeIterators() {
        for (Closeable closeable : this.closeables) {
            AbstractArchiver.closeQuietlyIfCloseable(closeable);
        }
    }

    protected abstract void close() throws IOException;

    protected void cleanUp() throws IOException {
        this.closeIterators();
        for (Object resource : this.resources) {
            if (resource instanceof PlexusIoProxyResourceCollection) {
                resource = ((PlexusIoProxyResourceCollection)resource).getSrc();
            }
            AbstractArchiver.closeIfCloseable(resource);
        }
        this.resources.clear();
    }

    protected abstract void execute() throws ArchiverException, IOException;

    @Override
    public boolean isUseJvmChmod() {
        return this.useJvmChmod;
    }

    @Override
    public void setUseJvmChmod(boolean useJvmChmod) {
        this.useJvmChmod = useJvmChmod;
    }

    @Override
    public boolean isIgnorePermissions() {
        return this.ignorePermissions;
    }

    @Override
    public void setIgnorePermissions(boolean ignorePermissions) {
        this.ignorePermissions = ignorePermissions;
    }

    @Override
    @Deprecated
    public void setLastModifiedDate(Date lastModifiedDate) {
        this.lastModifiedTime = lastModifiedDate != null ? FileTime.fromMillis(lastModifiedDate.getTime()) : null;
    }

    @Override
    @Deprecated
    public Date getLastModifiedDate() {
        return this.lastModifiedTime != null ? new Date(this.lastModifiedTime.toMillis()) : null;
    }

    @Override
    public void setLastModifiedTime(FileTime lastModifiedTime) {
        this.lastModifiedTime = lastModifiedTime;
    }

    @Override
    public FileTime getLastModifiedTime() {
        return this.lastModifiedTime;
    }

    @Override
    public void setFilenameComparator(Comparator<String> filenameComparator) {
        this.filenameComparator = filenameComparator;
    }

    public Comparator<String> getFilenameComparator() {
        return this.filenameComparator;
    }

    @Override
    public void setOverrideUid(int uid) {
        this.overrideUid = uid;
    }

    @Override
    public void setOverrideUserName(String userName) {
        this.overrideUserName = userName;
    }

    @Override
    public int getOverrideUid() {
        return this.overrideUid;
    }

    @Override
    public String getOverrideUserName() {
        return this.overrideUserName;
    }

    @Override
    public void setOverrideGid(int gid) {
        this.overrideGid = gid;
    }

    @Override
    public void setOverrideGroupName(String groupName) {
        this.overrideGroupName = groupName;
    }

    @Override
    public int getOverrideGid() {
        return this.overrideGid;
    }

    @Override
    public String getOverrideGroupName() {
        return this.overrideGroupName;
    }

    @Override
    public void setUmask(int umask) {
        this.umask = umask;
    }

    @Override
    public int getUmask() {
        return this.umask;
    }

    @Override
    @Deprecated
    public void configureReproducible(Date lastModifiedDate) {
        this.configureReproducibleBuild(FileTime.fromMillis(lastModifiedDate.getTime()));
    }

    @Override
    public void configureReproducibleBuild(FileTime lastModifiedTime) {
        this.setLastModifiedTime(this.normalizeLastModifiedTime(lastModifiedTime));
        this.setFilenameComparator(String::compareTo);
        this.setOverrideUid(0);
        this.setOverrideUserName("root");
        this.setOverrideGid(0);
        this.setOverrideGroupName("root");
        this.setUmask(18);
    }

    protected FileTime normalizeLastModifiedTime(FileTime lastModifiedTime) {
        return lastModifiedTime;
    }

    private static class AddedResourceCollection {
        private final PlexusIoResourceCollection resources;
        private final int forcedFileMode;
        private final int forcedDirectoryMode;

        public AddedResourceCollection(PlexusIoResourceCollection resources, int forcedFileMode, int forcedDirMode) {
            this.resources = resources;
            this.forcedFileMode = forcedFileMode;
            this.forcedDirectoryMode = forcedDirMode;
        }

        private int maybeOverridden(int suggestedMode, boolean isDir) {
            if (isDir) {
                return this.forcedDirectoryMode >= 0 ? this.forcedDirectoryMode : suggestedMode;
            }
            return this.forcedFileMode >= 0 ? this.forcedFileMode : suggestedMode;
        }
    }
}

