/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.connector.basic;

import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import javax.inject.Inject;
import javax.inject.Named;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.connector.basic.BasicRepositoryConnector;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.spi.checksums.ProvidedChecksumsSource;
import org.eclipse.aether.spi.connector.RepositoryConnector;
import org.eclipse.aether.spi.connector.RepositoryConnectorFactory;
import org.eclipse.aether.spi.connector.checksum.ChecksumPolicyProvider;
import org.eclipse.aether.spi.connector.layout.RepositoryLayoutProvider;
import org.eclipse.aether.spi.connector.transport.TransporterProvider;
import org.eclipse.aether.spi.io.FileProcessor;
import org.eclipse.aether.spi.locator.Service;
import org.eclipse.aether.spi.locator.ServiceLocator;
import org.eclipse.aether.transfer.NoRepositoryConnectorException;

@Named(value="basic")
public final class BasicRepositoryConnectorFactory
implements RepositoryConnectorFactory,
Service {
    private TransporterProvider transporterProvider;
    private RepositoryLayoutProvider layoutProvider;
    private ChecksumPolicyProvider checksumPolicyProvider;
    private FileProcessor fileProcessor;
    private Map<String, ProvidedChecksumsSource> providedChecksumsSources;
    private float priority;

    @Deprecated
    public BasicRepositoryConnectorFactory() {
    }

    @Inject
    public BasicRepositoryConnectorFactory(TransporterProvider transporterProvider, RepositoryLayoutProvider layoutProvider, ChecksumPolicyProvider checksumPolicyProvider, FileProcessor fileProcessor, Map<String, ProvidedChecksumsSource> providedChecksumsSources) {
        this.setTransporterProvider(transporterProvider);
        this.setRepositoryLayoutProvider(layoutProvider);
        this.setChecksumPolicyProvider(checksumPolicyProvider);
        this.setFileProcessor(fileProcessor);
        this.setProvidedChecksumSources(providedChecksumsSources);
    }

    @Override
    public void initService(ServiceLocator locator) {
        this.setTransporterProvider(locator.getService(TransporterProvider.class));
        this.setRepositoryLayoutProvider(locator.getService(RepositoryLayoutProvider.class));
        this.setChecksumPolicyProvider(locator.getService(ChecksumPolicyProvider.class));
        this.setFileProcessor(locator.getService(FileProcessor.class));
        this.setProvidedChecksumSources(Collections.emptyMap());
    }

    public BasicRepositoryConnectorFactory setTransporterProvider(TransporterProvider transporterProvider) {
        this.transporterProvider = Objects.requireNonNull(transporterProvider, "transporter provider cannot be null");
        return this;
    }

    public BasicRepositoryConnectorFactory setRepositoryLayoutProvider(RepositoryLayoutProvider layoutProvider) {
        this.layoutProvider = Objects.requireNonNull(layoutProvider, "repository layout provider cannot be null");
        return this;
    }

    public BasicRepositoryConnectorFactory setChecksumPolicyProvider(ChecksumPolicyProvider checksumPolicyProvider) {
        this.checksumPolicyProvider = Objects.requireNonNull(checksumPolicyProvider, "checksum policy provider cannot be null");
        return this;
    }

    public BasicRepositoryConnectorFactory setFileProcessor(FileProcessor fileProcessor) {
        this.fileProcessor = Objects.requireNonNull(fileProcessor, "file processor cannot be null");
        return this;
    }

    public BasicRepositoryConnectorFactory setProvidedChecksumSources(Map<String, ProvidedChecksumsSource> providedChecksumsSources) {
        this.providedChecksumsSources = Objects.requireNonNull(providedChecksumsSources, "provided checksum sources cannot be null");
        return this;
    }

    @Override
    public float getPriority() {
        return this.priority;
    }

    public BasicRepositoryConnectorFactory setPriority(float priority) {
        this.priority = priority;
        return this;
    }

    @Override
    public RepositoryConnector newInstance(RepositorySystemSession session, RemoteRepository repository) throws NoRepositoryConnectorException {
        Objects.requireNonNull(session, "session cannot be null");
        Objects.requireNonNull(repository, "repository cannot be null");
        return new BasicRepositoryConnector(session, repository, this.transporterProvider, this.layoutProvider, this.checksumPolicyProvider, this.fileProcessor, this.providedChecksumsSources);
    }
}

