/*
 * Decompiled with CFR 0.152.
 */
package org.mule.metadata.message.api;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.mule.metadata.api.annotation.TypeAnnotation;
import org.mule.metadata.api.builder.ObjectFieldTypeBuilder;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.ObjectFieldType;
import org.mule.metadata.api.model.ObjectType;
import org.mule.metadata.api.model.impl.BaseMetadataType;
import org.mule.metadata.api.visitor.MetadataTypeVisitor;
import org.mule.metadata.message.api.MessageMetadataType;

class DefaultMessageMetadataType
extends BaseMetadataType
implements ObjectType,
MessageMetadataType {
    public static final String PAYLOAD_FIELD_NAME = "payload";
    public static final String ATTRIBUTES_FIELD_NAME = "attributes";
    private final Optional<ObjectFieldType> payloadMetadataType;
    private final Optional<ObjectFieldType> attributes;
    private Object[] fieldValues;

    DefaultMessageMetadataType(Optional<MetadataType> payloadMetadataType, Optional<MetadataType> attributes, Map<Class<? extends TypeAnnotation>, TypeAnnotation> annotations) {
        this(payloadMetadataType, null, attributes, null, annotations);
    }

    DefaultMessageMetadataType(Optional<MetadataType> payloadMetadataType, Consumer<ObjectFieldTypeBuilder> payloadObjectFieldTypeBuilderConsumer, Optional<MetadataType> attributes, Consumer<ObjectFieldTypeBuilder> attributesObjectFieldTypeBuilderConsumer, Map<Class<? extends TypeAnnotation>, TypeAnnotation> annotations) {
        super(MetadataFormat.JAVA, annotations);
        this.payloadMetadataType = payloadMetadataType.map(type -> {
            ObjectFieldTypeBuilder objectFieldTypeBuilder = new ObjectFieldTypeBuilder(MetadataFormat.JAVA);
            objectFieldTypeBuilder.key(PAYLOAD_FIELD_NAME).required(true).value((MetadataType)type);
            Optional.ofNullable(payloadObjectFieldTypeBuilderConsumer).ifPresent(objectFieldTypeBuilderConsumer -> payloadObjectFieldTypeBuilderConsumer.accept(objectFieldTypeBuilder));
            return objectFieldTypeBuilder.build();
        });
        this.attributes = attributes.map(type -> {
            ObjectFieldTypeBuilder objectFieldTypeBuilder = new ObjectFieldTypeBuilder(MetadataFormat.JAVA);
            objectFieldTypeBuilder.key(ATTRIBUTES_FIELD_NAME).required(true).value((MetadataType)type);
            Optional.ofNullable(payloadObjectFieldTypeBuilderConsumer).ifPresent(objectFieldTypeBuilderConsumer -> attributesObjectFieldTypeBuilderConsumer.accept(objectFieldTypeBuilder));
            return objectFieldTypeBuilder.build();
        });
    }

    @Override
    public Optional<MetadataType> getOpenRestriction() {
        return Optional.empty();
    }

    @Override
    public Collection<ObjectFieldType> getFields() {
        return Stream.of(this.payloadMetadataType, this.attributes).filter(t2 -> t2.isPresent()).map(t2 -> (ObjectFieldType)t2.get()).collect(Collectors.toList());
    }

    @Override
    public boolean isOrdered() {
        return false;
    }

    @Override
    public Optional<ObjectFieldType> getFieldByName(String name) {
        switch (name) {
            case "payload": {
                return this.payloadMetadataType;
            }
            case "attributes": {
                return this.attributes;
            }
        }
        return Optional.empty();
    }

    @Override
    public void accept(MetadataTypeVisitor metadataTypeVisitor) {
        metadataTypeVisitor.visitObject(this);
    }

    @Override
    public Optional<MetadataType> getPayloadType() {
        return this.payloadMetadataType.map(ObjectFieldType::getValue);
    }

    @Override
    public Optional<Set<TypeAnnotation>> getPayloadAnnotations() {
        return this.payloadMetadataType.map(MetadataType::getAnnotations);
    }

    @Override
    public <T extends TypeAnnotation> Optional<T> getPayloadAnnotation(Class<T> annotation) {
        return this.payloadMetadataType.flatMap(t2 -> t2.getAnnotation(annotation));
    }

    @Override
    public Optional<MetadataType> getAttributesType() {
        return this.attributes.map(ObjectFieldType::getValue);
    }

    @Override
    public Optional<Set<TypeAnnotation>> getAttributesAnnotations() {
        return this.attributes.map(MetadataType::getAnnotations);
    }

    @Override
    public <T extends TypeAnnotation> Optional<T> getAttributesAnnotation(Class<T> annotation) {
        return this.attributes.flatMap(t2 -> t2.getAnnotation(annotation));
    }

    @Override
    public Object[] getFieldValues() {
        if (this.fieldValues == null) {
            this.fieldValues = this.createFieldValuesArray();
        }
        return this.fieldValues;
    }

    private Object[] createFieldValuesArray() {
        ArrayList fieldValues = new ArrayList();
        Collections.addAll(fieldValues, super.getFieldValues());
        Collections.addAll(fieldValues, this.payloadMetadataType, this.attributes);
        return fieldValues.toArray(new Object[fieldValues.size()]);
    }
}

