/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.remote.api.configuration;

import com.google.common.base.Preconditions;
import java.util.Collections;
import java.util.Set;

public class CoverageConfiguration {
    public static final int ILLEGAL_PORT_NUMBER = -1;
    private Boolean runCoverage;
    private Boolean randomizeCoveragePort = true;
    private Integer coveragePort = -1;
    private Set<String> suitePaths = Collections.emptySet();
    private Set<String> ignoredFiles = Collections.emptySet();
    private Set<String> ignoredFlowNames = Collections.emptySet();

    private CoverageConfiguration(Boolean runCoverage, Set<String> suitePaths, Set<String> ignoredFlowNames, Set<String> ignoredFiles, Boolean randomizeCoveragePort, Integer coveragePort) {
        this.runCoverage = runCoverage;
        this.suitePaths = suitePaths;
        this.ignoredFlowNames = ignoredFlowNames;
        this.ignoredFiles = ignoredFiles;
        this.randomizeCoveragePort = randomizeCoveragePort;
        this.coveragePort = coveragePort;
    }

    public Boolean isRunCoverage() {
        return this.runCoverage;
    }

    public Set<String> getSuitePaths() {
        return this.suitePaths;
    }

    public Set<String> getIgnoredFlowNames() {
        return this.ignoredFlowNames;
    }

    public Set<String> getIgnoredFiles() {
        return this.ignoredFiles;
    }

    public Integer getCoveragePort() {
        return this.coveragePort;
    }

    public Boolean isRandomizeCoveragePort() {
        return this.randomizeCoveragePort;
    }

    public static class CoverageConfigurationBuilder {
        private Boolean runCoverage = Boolean.FALSE;
        private Set<String> suitePaths = Collections.emptySet();
        private Set<String> ignoredFiles = Collections.emptySet();
        private Set<String> ignoredFlowNames = Collections.emptySet();
        private Integer coveragePort;
        private Boolean randomizeCoveragePort = true;

        public CoverageConfigurationBuilder withShouldRunCoverage(Boolean shouldRunCoverage) {
            Preconditions.checkNotNull(this.runCoverage, "runCoverage must not be null");
            this.runCoverage = shouldRunCoverage;
            return this;
        }

        public CoverageConfigurationBuilder withSuitePaths(Set<String> suitePaths) {
            Preconditions.checkNotNull(suitePaths, "Suite path list  must not be null");
            this.suitePaths = suitePaths;
            return this;
        }

        public CoverageConfigurationBuilder withIgnoredFlowNames(Set<String> ignoredFlowNames) {
            Preconditions.checkNotNull(ignoredFlowNames, "Ignored Flow Names list must not be null");
            this.ignoredFlowNames = ignoredFlowNames;
            return this;
        }

        public CoverageConfigurationBuilder withIgnoredFiles(Set<String> ignoredFiles) {
            Preconditions.checkNotNull(ignoredFiles, "Ignored files must not be null");
            this.ignoredFiles = ignoredFiles;
            return this;
        }

        public CoverageConfigurationBuilder withCoveragePort(Integer coveragePort) {
            Preconditions.checkNotNull(coveragePort, "Coverage port must not be null");
            Preconditions.checkArgument(coveragePort > 0, "Coverage port must be a positive number");
            this.coveragePort = coveragePort;
            this.randomizeCoveragePort = false;
            return this;
        }

        public CoverageConfiguration build() {
            return new CoverageConfiguration(this.runCoverage, this.suitePaths, this.ignoredFlowNames, this.ignoredFiles, this.randomizeCoveragePort, this.coveragePort);
        }
    }
}

