/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.remote.container.cloudhub;

import com.google.common.base.Preconditions;
import com.google.common.io.ByteStreams;
import com.google.gson.Gson;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.concurrent.TimeoutException;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import javax.ws.rs.core.Response;
import org.mule.munit.common.exception.MunitError;
import org.mule.munit.common.protocol.listeners.RemoteRunEventListener;
import org.mule.munit.common.protocol.listeners.RunEventListener;
import org.mule.munit.common.protocol.message.RunMessageParser;
import org.mule.munit.remote.api.configuration.CloudHubContainerConfiguration;
import org.mule.munit.remote.api.configuration.RunConfiguration;
import org.mule.munit.remote.container.Container;
import org.mule.munit.remote.container.SuiteRunDispatcher;
import org.mule.munit.remote.container.cloudhub.logging.CloudHubLoggingTask;
import org.mule.munit.remote.logging.MunitDeployerLog;
import org.mule.munit.remote.tools.client.BAT.BATClientBase;
import org.mule.munit.remote.tools.client.BAT.model.response.ExecutionResponse;
import org.mule.munit.remote.tools.client.BAT.model.response.ExecutionResultResponse;
import org.mule.munit.remote.tools.client.BAT.model.response.ExecutionStatus;
import org.mule.tools.client.OperationRetrier;
import org.mule.tools.client.cloudhub.CloudHubClient;
import org.mule.tools.client.core.exception.ClientException;
import org.mule.tools.client.core.exception.DeploymentException;
import org.mule.tools.deployment.DefaultDeployer;
import org.mule.tools.deployment.Deployer;
import org.mule.tools.model.anypoint.CloudHubDeployment;
import org.mule.tools.utils.DeployerLog;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CloudHubRunDispatcher
implements SuiteRunDispatcher {
    private transient Logger logger = LoggerFactory.getLogger(this.getClass());
    public static final long UNDEPLOYMENT_RETRIER_SLEEP_TIME = 2000L;
    public static final int UNDEPLOYMENT_RETRIER_ATTEMPS = 60;
    public static final int DEFAULT_TIMEOUT = 1800000;
    public static final long RESULT_RETRIER_SLEEP_TIME = 10000L;
    public static final int RESULT_RETRIER_ATTEMPS = 900;
    public static final String CLOUDHUB_DASHBOARD_URL_FORMAT = "cloudhub/#/console/applications/cloudhub/%s/logging";
    protected Deployer deployer;
    protected RunConfiguration runConfiguration;
    protected CloudHubDeployment deployment;
    protected DeployerLog deployerLog;
    private final CloudHubContainerConfiguration containerConfiguration;
    private final CloudHubClient cloudHubClient;
    private final BATClientBase batClient;

    public CloudHubRunDispatcher(RunConfiguration runConfiguration, CloudHubClient cloudHubClient, BATClientBase batClient) {
        Preconditions.checkArgument(runConfiguration != null, "runConfiguration must not be null");
        Preconditions.checkArgument(runConfiguration.getContainerConfiguration() instanceof CloudHubContainerConfiguration, "containerConfiguration must be instance of CloudHubContainerConfiguration");
        Preconditions.checkArgument(cloudHubClient != null, "cloudHubClient must not be null");
        Preconditions.checkArgument(batClient != null, "batClient must not be null");
        this.runConfiguration = runConfiguration;
        this.cloudHubClient = cloudHubClient;
        this.containerConfiguration = (CloudHubContainerConfiguration)runConfiguration.getContainerConfiguration();
        Preconditions.checkArgument(this.containerConfiguration.getDeploymentConfiguration().getDeployment() instanceof CloudHubDeployment, "deployment must be instance of CloudHubDeployment");
        CloudHubContainerConfiguration containerConfiguration = (CloudHubContainerConfiguration)runConfiguration.getContainerConfiguration();
        this.deployment = (CloudHubDeployment)containerConfiguration.getDeploymentConfiguration().getDeployment();
        this.deployerLog = new MunitDeployerLog(containerConfiguration.isDebugEnabled());
        this.batClient = batClient;
    }

    @Override
    public void runSuites(RemoteRunEventListener listener) throws org.mule.munit.remote.exception.DeploymentException {
        this.deployApplication();
        try {
            String urlDashboard = this.deployment.getUri() + String.format(CLOUDHUB_DASHBOARD_URL_FORMAT, this.deployment.getApplicationName());
            this.logger.info("Running MUnit on CloudHub. Track the progress on: " + urlDashboard);
            OperationRetrier retrier = new OperationRetrier();
            retrier.setAttempts(900);
            retrier.setSleepTime(10000L);
            retrier.retry(() -> {
                try {
                    String executionId = this.containerConfiguration.getExecutionId();
                    ExecutionResponse response = this.batClient.getExecution(executionId);
                    if (response.getStatus() == ExecutionStatus.ENDED) {
                        ExecutionResultResponse result = this.batClient.getExecutionResult(executionId);
                        RunMessageParser parser = new RunMessageParser((RunEventListener)listener);
                        Gson gson = new Gson();
                        result.getData().forEach(runMessage -> parser.parseAndNotify(gson.toJson(runMessage)));
                        return false;
                    }
                    if (response.getStatus() == ExecutionStatus.ERROR) {
                        throw new MunitError("An error occurred running MUnit on CloudHub.");
                    }
                    return true;
                }
                catch (ClientException httpException) {
                    if (httpException.getStatusCode() == Response.Status.UNAUTHORIZED.getStatusCode()) {
                        this.batClient.renewToken();
                        return true;
                    }
                    throw new MunitError("An error occurred trying to retrieve the Execution.");
                }
            });
        }
        catch (InterruptedException | TimeoutException e) {
            throw new MunitError("Tests timeout after 1800000 milliseconds");
        }
        finally {
            this.cloudHubClient.renewToken();
            CloudHubLoggingTask loggingTask = this.getCloudhubLogger();
            loggingTask.log();
            this.undeployApplication();
        }
    }

    protected void deployApplication() throws org.mule.munit.remote.exception.DeploymentException {
        this.logger.info("CloudHub deploying application");
        try {
            Path munitWorkingPath = new File(this.runConfiguration.getContainerConfiguration().getMunitWorkingDirectoryPath()).toPath();
            String jarFilename = this.runConfiguration.getProjectName() + ".jar";
            this.replaceLog4j();
            this.generateJar(munitWorkingPath.resolve(this.runConfiguration.getProjectName()).toFile(), munitWorkingPath.resolve(jarFilename).toFile());
            this.deployment.setArtifact(new File(this.runConfiguration.getContainerConfiguration().getMunitWorkingDirectoryPath()).toPath().resolve(jarFilename).toFile());
            this.deployer = this.getDeployer();
            this.setProperties(this.deployment);
            this.deployment.setSkipDeploymentVerification(true);
            this.deployer.deploy();
        }
        catch (Exception e) {
            throw new org.mule.munit.remote.exception.DeploymentException("An error occurred while deploying application: " + e.getMessage(), e);
        }
    }

    protected void undeployApplication() {
        this.logger.info("CloudHub undeploying application");
        try {
            if (this.deployer != null) {
                this.deployer.undeploy();
                this.waitUndeploymentFinish();
            }
        }
        catch (ClientException | DeploymentException e) {
            this.logger.error("An error occurred while undeploying application: " + e.getMessage());
        }
    }

    protected void generateJar(File srcFolder, File destJarFile) throws IOException {
        try (FileOutputStream fileWriter = new FileOutputStream(destJarFile);
             JarOutputStream jar = new JarOutputStream(fileWriter);){
            for (File file : srcFolder.listFiles()) {
                this.addFileToJar("", file, jar);
            }
        }
    }

    private void addFileToJar(String prefix, File srcFile, JarOutputStream jar) throws IOException {
        if (srcFile.isDirectory()) {
            for (File file : srcFile.listFiles()) {
                String newPrefix = prefix + srcFile.getName() + "/";
                this.addFileToJar(newPrefix, file, jar);
            }
        } else {
            try (FileInputStream in = new FileInputStream(srcFile);){
                jar.putNextEntry(new JarEntry(prefix + srcFile.getName()));
                ByteStreams.copy(in, jar);
            }
        }
    }

    protected void replaceLog4j() {
        Path munitWorkingPath = new File(this.runConfiguration.getContainerConfiguration().getMunitWorkingDirectoryPath()).toPath();
        Path appWorkingPath = munitWorkingPath.resolve(this.runConfiguration.getProjectName());
        appWorkingPath.resolve("log4j2.xml").toFile().delete();
        appWorkingPath.resolve("log4j2-test.xml").toFile().renameTo(appWorkingPath.resolve("log4j2.xml").toFile());
    }

    private void setProperties(CloudHubDeployment deployment) {
        CloudHubDeployment anypointDeployment;
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("mule.application.deployment.lazyConnections", Container.enableLazyConnections().toString());
        properties.put("mule.application.deployment.lazyInit", Container.enableLazyInitialization().toString());
        if (this.containerConfiguration.getSystemPropertyVariables() != null && !this.containerConfiguration.getSystemPropertyVariables().isEmpty()) {
            properties.putAll(this.containerConfiguration.getSystemPropertyVariables());
        }
        if (this.containerConfiguration.getEnvironmentVariables() != null && !this.containerConfiguration.getEnvironmentVariables().isEmpty()) {
            properties.putAll(this.containerConfiguration.getEnvironmentVariables());
        }
        if ((anypointDeployment = deployment).getProperties() != null) {
            properties.putAll(anypointDeployment.getProperties());
        }
        anypointDeployment.setProperties(properties);
    }

    private void waitUndeploymentFinish() {
        OperationRetrier retrier = new OperationRetrier();
        retrier.setAttempts(60);
        retrier.setSleepTime(2000L);
        try {
            retrier.retry(() -> this.cloudHubClient.isDomainAvailable(this.deployment.getApplicationName()));
        }
        catch (InterruptedException | TimeoutException e) {
            this.logger.debug("waitUndeploymentFinish timeout.");
        }
    }

    protected Deployer getDeployer() throws DeploymentException {
        return new DefaultDeployer(this.deployment, this.deployerLog);
    }

    private CloudHubLoggingTask getCloudhubLogger() {
        return new CloudHubLoggingTask(this.deployerLog, this.cloudHubClient, this.cloudHubClient.getApplications(this.deployment.getApplicationName()));
    }
}

