/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.remote.container.cloudhub.logging;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import org.mule.tools.client.cloudhub.CloudHubClient;
import org.mule.tools.client.cloudhub.model.Application;
import org.mule.tools.client.cloudhub.model.Deployment;
import org.mule.tools.utils.DeployerLog;

public class CloudHubLoggingTask {
    private final DeployerLog deployerLog;
    private final CloudHubClient cloudHubClient;
    private final Application application;

    public CloudHubLoggingTask(DeployerLog deployerLog, CloudHubClient cloudHubClient, Application application) {
        this.deployerLog = deployerLog;
        this.cloudHubClient = cloudHubClient;
        this.application = application;
    }

    public void log() {
        try {
            List<Deployment> deployments = this.cloudHubClient.getDeployments(this.application);
            this.getLastDeployment(deployments).ifPresent(chDeployment -> chDeployment.getInstances().stream().findFirst().ifPresent(instance -> {
                try (InputStream logs = this.cloudHubClient.getEntireLogs(this.application, instance.getInstanceId());){
                    String readLine;
                    BufferedReader br = new BufferedReader(new InputStreamReader(logs));
                    while ((readLine = br.readLine()) != null) {
                        System.out.println(readLine);
                    }
                }
                catch (IOException e) {
                    this.deployerLog.error("Unable to retrieve logs - " + e.getMessage());
                }
            }));
        }
        catch (Exception e) {
            this.deployerLog.error("Unable to retrieve logs - " + e.getMessage());
        }
    }

    private Optional<Deployment> getLastDeployment(List<Deployment> deployments) {
        return deployments.stream().max(Comparator.comparing(Deployment::getCreateTime));
    }
}

