/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.remote.coverage;

import com.google.common.base.Preconditions;
import java.util.Collections;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import org.mule.munit.common.util.FreePortFinder;
import org.mule.munit.plugins.coverage.core.model.CoverageComponentLocation;
import org.mule.munit.plugins.coverage.report.ApplicationCoverageReportBuilder;
import org.mule.munit.plugins.coverage.report.model.ApplicationCoverageReport;
import org.mule.munit.plugins.coverage.server.CoverageLocations;
import org.mule.munit.plugins.coverage.server.CoverageLocationsAccumulator;
import org.mule.munit.plugins.coverage.server.CoverageServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CoverageManager
implements CoverageLocationsAccumulator {
    private static final int MIN_PORT_NUMBER = 50000;
    private static final int MAX_PORT_NUMBER = 50500;
    private static final String COVERAGE_PORT_PROPERTY = "coverage.port";
    private transient Logger logger = LoggerFactory.getLogger(this.getClass());
    private boolean shouldCalculateCoverage;
    protected Set<String> suitePaths;
    protected Set<String> ignoreFlows = Collections.emptySet();
    protected Set<String> ignoreFiles = Collections.emptySet();
    protected CoverageServer coverageServer;
    protected Set<CoverageComponentLocation> allLocations = new HashSet<CoverageComponentLocation>();
    protected Set<CoverageComponentLocation> coveredLocations = new HashSet<CoverageComponentLocation>();

    public CoverageManager(Boolean randomizeCoveragePort, Integer serverPort, Boolean shouldRunCoverage, Set<String> suitePaths) {
        Preconditions.checkNotNull(randomizeCoveragePort, "Randomize coverage port must not null");
        Preconditions.checkNotNull(suitePaths, "The suite path list  must not be null");
        Preconditions.checkArgument(!suitePaths.isEmpty(), "The suite path list  must not be empty");
        this.suitePaths = suitePaths;
        this.shouldCalculateCoverage = shouldRunCoverage;
        if (randomizeCoveragePort.booleanValue()) {
            serverPort = new FreePortFinder(50000, 50500).find();
            System.setProperty(COVERAGE_PORT_PROPERTY, serverPort.toString());
        } else {
            Preconditions.checkNotNull(serverPort, "The server port must not null");
        }
        this.coverageServer = new CoverageServer(serverPort, this);
    }

    public void setIgnoreFlows(Set<String> ignoreFlows) {
        Preconditions.checkNotNull(ignoreFlows, "The ignored flows list must not null");
        this.ignoreFlows = ignoreFlows;
    }

    public void setIgnoreFiles(Set<String> ignoreFiles) {
        Preconditions.checkNotNull(ignoreFiles, "The ignored files list must not null");
        this.ignoreFiles = ignoreFiles;
    }

    public boolean shouldCalculateCoverage() {
        return this.shouldCalculateCoverage;
    }

    public void startCoverageServer() {
        if (this.shouldCalculateCoverage) {
            this.logger.info("Starting coverage server");
            this.coverageServer.launch();
        }
    }

    public void stopCoverageServer() {
        if (this.shouldCalculateCoverage) {
            this.logger.info("Shutting down coverage server");
            this.coverageServer.shutDown();
        }
    }

    @Override
    public synchronized void accumulateCoverageLocations(CoverageLocations coverageLocations) {
        Preconditions.checkNotNull(coverageLocations, "The covered locations must not be null");
        this.logger.info("accumulating covered locations");
        if (coverageLocations.isAllLocations().booleanValue()) {
            this.allLocations.addAll(coverageLocations.getCoverageLocations());
        } else {
            this.coveredLocations.addAll(coverageLocations.getCoverageLocations());
        }
    }

    public Optional<ApplicationCoverageReport> generateCoverageReport() {
        if (this.shouldCalculateCoverage) {
            this.logger.info("Calculating application coverage");
            ApplicationCoverageReportBuilder reportBuilder = this.getApplicationCoverageReportBuilder();
            return Optional.of(reportBuilder.build());
        }
        return Optional.empty();
    }

    protected ApplicationCoverageReportBuilder getApplicationCoverageReportBuilder() {
        ApplicationCoverageReportBuilder reportBuilder = new ApplicationCoverageReportBuilder(this.allLocations, this.coveredLocations, this.suitePaths);
        reportBuilder.setFlowsToIgnore(this.ignoreFlows);
        reportBuilder.setFilesToIgnore(this.ignoreFiles);
        return reportBuilder;
    }
}

