/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.api.connection.serialization;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.io.StringWriter;
import org.mule.runtime.api.message.ErrorType;

public class ErrorTypeSerializer {
    private static final String IDENTIFIER = "identifier";
    private static final String NAMESPACE = "namespace";
    private static final String PARENT = "parent";

    private ErrorTypeSerializer() {
    }

    public static ErrorTypeSerializer create() {
        return new ErrorTypeSerializer();
    }

    public String serialize(ErrorType errorType) throws IOException {
        StringWriter stringWriter = new StringWriter();
        JsonWriter out = new JsonWriter(stringWriter);
        if (errorType == null) {
            out.nullValue();
        } else {
            out.beginObject();
            out.name(IDENTIFIER).value(errorType.getIdentifier());
            out.name(NAMESPACE).value(errorType.getNamespace());
            ErrorType parentErrorType = errorType.getParentErrorType();
            if (parentErrorType != null) {
                out.name(PARENT);
                out.jsonValue(this.serialize(parentErrorType));
            }
            out.endObject();
        }
        return stringWriter.toString();
    }

    public ErrorType deserialize(String errorType) {
        JsonElement parse = new JsonParser().parse(errorType);
        return this.getErrorType(parse);
    }

    private ErrorType getErrorType(JsonElement parse) {
        JsonObject asJsonObject = parse.getAsJsonObject();
        String identifier = asJsonObject.getAsJsonPrimitive(IDENTIFIER).getAsString();
        String namespace = asJsonObject.getAsJsonPrimitive(NAMESPACE).getAsString();
        ErrorType parent = null;
        if (asJsonObject.has(PARENT)) {
            parent = this.getErrorType(asJsonObject.get(PARENT));
        }
        return new SerializationErrorTypeImplementation(identifier, namespace, parent);
    }

    private class SerializationErrorTypeImplementation
    implements ErrorType {
        private final String identifier;
        private final String namespace;
        private final ErrorType parent;

        SerializationErrorTypeImplementation(String identifier, String namespace, ErrorType parent) {
            this.identifier = identifier;
            this.namespace = namespace;
            this.parent = parent;
        }

        @Override
        public String getIdentifier() {
            return this.identifier;
        }

        @Override
        public String getNamespace() {
            return this.namespace;
        }

        @Override
        public ErrorType getParentErrorType() {
            return this.parent;
        }
    }
}

