/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.api.exception;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.naming.Name;
import javax.naming.NamingException;
import org.mule.runtime.api.legacy.exception.ExceptionReader;

class NamingExceptionReader
implements ExceptionReader {
    protected static final String MISSING_NAME_DISPLAY_VALUE = "<none>";

    NamingExceptionReader() {
    }

    @Override
    public String getMessage(Throwable t2) {
        return t2 instanceof NamingException ? ((NamingException)t2).toString(true) : "<unknown>";
    }

    @Override
    public Throwable getCause(Throwable t2) {
        return t2 instanceof NamingException ? ((NamingException)t2).getCause() : null;
    }

    @Override
    public Class<?> getExceptionType() {
        return NamingException.class;
    }

    @Override
    public Map<String, Object> getInfo(Throwable t2) {
        if (t2 instanceof NamingException) {
            NamingException e = (NamingException)t2;
            HashMap<String, Object> info = new HashMap<String, Object>();
            Name remainingName = e.getRemainingName();
            Name resolvedName = e.getResolvedName();
            info.put("Remaining Name", remainingName == null ? MISSING_NAME_DISPLAY_VALUE : remainingName.toString());
            info.put("Resolved Name", resolvedName == null ? MISSING_NAME_DISPLAY_VALUE : resolvedName.toString());
            return info;
        }
        return Collections.emptyMap();
    }
}

