/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.api.util;

import java.util.Locale;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.api.util.Preconditions;

public final class IdentifierParsingUtils {
    private static final String SEPARATOR = ":";

    private IdentifierParsingUtils() {
    }

    public static ComponentIdentifier parseComponentIdentifier(String stringRepresentation, String defaultNamespace) {
        return IdentifierParsingUtils.parseIdentifier(stringRepresentation, defaultNamespace, false);
    }

    public static ComponentIdentifier parseErrorType(String stringRepresentation, String defaultNamespace) {
        return IdentifierParsingUtils.parseIdentifier(stringRepresentation, defaultNamespace, true);
    }

    private static ComponentIdentifier parseIdentifier(String stringRepresentation, String defaultNamespace, boolean toUpperCase) {
        String identifier;
        String namespace;
        Preconditions.checkArgument(!StringUtils.isEmpty(stringRepresentation), "identifier cannot be an empty string or null");
        String[] values = stringRepresentation.split(SEPARATOR);
        if (values.length == 2) {
            namespace = values[0];
            identifier = values[1];
        } else {
            namespace = defaultNamespace;
            identifier = values[0];
        }
        if (toUpperCase) {
            namespace = namespace.toUpperCase(Locale.getDefault());
            identifier = identifier.toUpperCase(Locale.getDefault());
        }
        return ComponentIdentifier.builder().namespace(namespace).name(identifier).build();
    }

    public static Optional<String> getNamespace(String stringRepresentation) {
        int indexOfSeparator = stringRepresentation.indexOf(SEPARATOR);
        if (indexOfSeparator == -1) {
            return Optional.empty();
        }
        return Optional.of(stringRepresentation.substring(0, indexOfSeparator));
    }
}

