/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.embedded.internal.classloading;

import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.mule.runtime.module.embedded.internal.classloading.ClassLoaderFilter;
import org.mule.runtime.module.embedded.internal.classloading.ExportedService;
import org.mule.runtime.module.embedded.internal.classloading.FilteringClassLoader;
import org.mule.runtime.module.embedded.internal.classloading.JreExplorer;

public class JdkOnlyClassLoaderFactory {
    public static final Set<String> BOOT_PACKAGES = ImmutableSet.of("com.yourkit");
    private static final Set<String> PACKAGES_TO_EXCLUDE = new HashSet<String>(Arrays.asList("org.slf4j", "org.eclipse.aether", "org.apache.maven", "org.sonatype.plexus", "org.mule.maven"));

    public static FilteringClassLoader create(ClassLoader parentClassLoader, Set<String> additionalExportedBootPackages) {
        Set<String> packages = new HashSet<String>(1024);
        HashSet<String> exportedResources = new HashSet<String>(1024);
        ArrayList<ExportedService> services = new ArrayList<ExportedService>(128);
        JreExplorer.exploreJdk(packages, exportedResources, services);
        packages = JdkOnlyClassLoaderFactory.sanitizeExportedPackages(packages);
        ClassLoaderFilter classLoaderFilter = new ClassLoaderFilter(JdkOnlyClassLoaderFactory.getExportedBootPackages(packages, additionalExportedBootPackages), exportedResources);
        return new FilteringClassLoader(parentClassLoader, classLoaderFilter, services);
    }

    private static Set<String> sanitizeExportedPackages(Set<String> packages) {
        return packages.stream().filter(p -> PACKAGES_TO_EXCLUDE.stream().noneMatch(p::startsWith)).collect(Collectors.toSet());
    }

    public static FilteringClassLoader create(ClassLoader parentClassLoader) {
        return JdkOnlyClassLoaderFactory.create(parentClassLoader, Collections.emptySet());
    }

    private static Set<String> getExportedBootPackages(Set<String> packages, Set<String> additionalExportedBootPackages) {
        return ((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)ImmutableSet.builder().addAll(BOOT_PACKAGES)).addAll(packages)).addAll(additionalExportedBootPackages)).build();
    }
}

