/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.api.verifier.policy;

import com.google.common.base.Preconditions;
import java.io.File;
import java.io.FileInputStream;
import java.util.List;
import org.mule.tools.api.exception.ValidationException;
import org.mule.tools.api.verifier.policy.ConfigurationProperty;
import org.mule.tools.api.verifier.policy.PolicyYaml;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.Constructor;
import org.yaml.snakeyaml.representer.Representer;

public class PolicyYamlVerifier {
    private final String yamlFileName;
    private final String path;

    public PolicyYamlVerifier(String path, String yamlFileName) {
        this.path = path;
        this.yamlFileName = yamlFileName;
    }

    public void validate() throws ValidationException {
        try {
            Representer representer = new Representer();
            representer.getPropertyUtils().setSkipMissingProperties(true);
            Yaml yamlParser = new Yaml(new Constructor(PolicyYaml.class), representer);
            File yamlFile = new File(this.path, this.yamlFileName);
            this.checkNotNullFields((PolicyYaml)yamlParser.load(new FileInputStream(yamlFile)));
        }
        catch (Exception e) {
            throw new ValidationException(String.format("Error validating '%s'. %s", this.yamlFileName, e.getMessage()));
        }
    }

    private void checkNotNullFields(PolicyYaml policy) {
        Preconditions.checkArgument(policy.id != null, "Missing required creator property 'id'");
        Preconditions.checkArgument(policy.name != null, "Missing required creator property 'name'");
        Preconditions.checkArgument(policy.description != null, "Missing required creator property 'description'");
        Preconditions.checkArgument(policy.category != null, "Missing required creator property 'category'");
        Preconditions.checkArgument(policy.type != null, "Missing required creator property 'type'");
        Preconditions.checkArgument(policy.resourceLevelSupported != null, "Missing required creator property 'resourceLevelSupported'");
        Preconditions.checkArgument(policy.standalone != null, "Missing required creator property 'standalone'");
        Preconditions.checkArgument(policy.requiredCharacteristics != null, "Missing required creator property 'requiredCharacteristics'");
        Preconditions.checkArgument(policy.providedCharacteristics != null, "Missing required creator property 'providedCharacteristics'");
        Preconditions.checkArgument(policy.configuration != null, "Missing required creator property 'configuration'");
        this.validateConfigurationProperties(policy.configuration);
    }

    private void validateConfigurationProperties(List<ConfigurationProperty> configuration) {
        configuration.forEach(p -> {
            Preconditions.checkArgument(p.propertyName != null, "Missing required creator property 'propertyName'");
            Preconditions.checkArgument(p.type != null, "Missing required creator property 'type'");
        });
    }
}

