/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.client.core;

import com.google.gson.Gson;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.function.Supplier;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;
import org.glassfish.jersey.media.multipart.MultiPartFeature;
import org.mule.tools.client.core.exception.ClientException;
import org.mule.tools.client.core.logging.ClientLoggingFilter;
import org.mule.tools.utils.DeployerLog;

public abstract class AbstractClient {
    private String userAgent = "mule-deployer%s";
    protected DeployerLog log;
    private boolean isClientInitialized = false;

    public AbstractClient() {
    }

    public AbstractClient(DeployerLog log) {
        this.log = log;
    }

    protected Response post(String uri, String path, Entity entity) {
        this.initialize();
        return this.builder(uri, path).post(entity);
    }

    protected Response post(String uri, String path, Object entity) {
        this.initialize();
        return this.post(uri, path, Entity.entity(entity, MediaType.APPLICATION_JSON_TYPE));
    }

    protected Response post(String uri, Supplier<String> pathSupplier, Object entity) {
        this.initialize();
        return this.post(uri, pathSupplier.get(), Entity.entity(entity, MediaType.APPLICATION_JSON_TYPE));
    }

    protected Response put(String uri, String path, Entity entity) {
        this.initialize();
        return this.builder(uri, path).put(entity);
    }

    protected Response put(String uri, String path, Object entity) {
        this.initialize();
        return this.put(uri, path, Entity.entity(entity, MediaType.APPLICATION_JSON_TYPE));
    }

    protected Response delete(String uri, String path) {
        this.initialize();
        return this.builder(uri, path).delete();
    }

    protected Response get(String uri, String path) {
        this.initialize();
        return this.builder(uri, path).get();
    }

    protected Response get(String uri, Supplier<String> pathSupplier) {
        this.initialize();
        return this.builder(uri, pathSupplier.get()).get();
    }

    protected Response delete(String uri, Supplier<String> pathSupplier) {
        this.initialize();
        return this.builder(uri, pathSupplier.get()).delete();
    }

    protected <T> T get(String uri, String path, Class<T> clazz) {
        this.initialize();
        return this.get(uri, path).readEntity(clazz);
    }

    protected Response patch(String uri, Supplier<String> path, Object entity) {
        this.initialize();
        return this.patch(uri, path.get(), Entity.entity(entity, MediaType.APPLICATION_JSON_TYPE));
    }

    protected Response patch(String uri, String path, Entity entity) {
        this.initialize();
        Invocation.Builder builder = this.builder(uri, path);
        builder.property("jersey.config.client.httpUrlConnection.setMethodWorkaround", true);
        return builder.method("PATCH", entity);
    }

    public synchronized void initialize() {
        if (!this.isClientInitialized) {
            this.isClientInitialized = true;
            this.init();
        }
    }

    protected abstract void init();

    private Invocation.Builder builder(String uri, String path) {
        WebTarget target = this.getTarget(uri, path);
        Invocation.Builder builder = target.request(MediaType.APPLICATION_JSON_TYPE).header("User-Agent", this.getUserAgent());
        this.setBuilderProperties(builder);
        this.configureRequest(builder);
        return builder;
    }

    protected WebTarget getTarget(String uri, String path) {
        ClientBuilder builder = ClientBuilder.newBuilder();
        this.configureSecurityContext(builder);
        Client client = (Client)builder.build().register(MultiPartFeature.class);
        if (this.log != null && this.log.isDebugEnabled() && !this.isLoginRequest(path)) {
            client.register(new ClientLoggingFilter(this.log));
        }
        return client.target(uri).path(path);
    }

    private boolean isLoginRequest(String path) {
        return "/accounts/login".equals(path);
    }

    protected String getUserAgent() {
        Package classPackage = AbstractClient.class.getPackage();
        String implementationVersion = classPackage != null ? classPackage.getImplementationVersion() : "";
        String version = StringUtils.isNotBlank(implementationVersion) ? "/" + implementationVersion : "";
        return String.format(this.userAgent, version);
    }

    protected void configureRequest(Invocation.Builder builder) {
    }

    protected void configureSecurityContext(ClientBuilder builder) {
    }

    protected void checkResponseStatus(Response response) {
        if (Response.Status.Family.familyOf(response.getStatus()) != Response.Status.Family.SUCCESSFUL) {
            throw new ClientException(response);
        }
    }

    protected void checkResponseStatus(Response response, Response.Status ... expectedStatus) {
        ArrayList<Integer> success = new ArrayList<Integer>();
        for (Response.Status s2 : expectedStatus) {
            success.add(s2.getStatusCode());
        }
        Integer statusCode = response.getStatus();
        if (!success.contains(statusCode)) {
            throw new ClientException(response);
        }
    }

    protected <T> T readJsonEntity(Response response, Type type) {
        String jsonResponse = response.readEntity(String.class);
        return new Gson().fromJson(jsonResponse, type);
    }

    public void setUserAgent(String userAgent) {
        this.userAgent = userAgent;
    }

    private void setBuilderProperties(Invocation.Builder builder) {
        builder.property("jersey.config.client.request.entity.processing", "CHUNKED");
        builder.property("jersey.config.client.chunkedEncodingSize", 4096);
    }
}

