/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.remote.tools.client.BAT;

import com.google.gson.Gson;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;
import org.glassfish.jersey.media.multipart.BodyPart;
import org.glassfish.jersey.media.multipart.FormDataBodyPart;
import org.glassfish.jersey.media.multipart.FormDataMultiPart;
import org.glassfish.jersey.media.multipart.MultiPart;
import org.glassfish.jersey.media.multipart.file.FileDataBodyPart;
import org.mule.munit.remote.tools.client.BAT.model.request.CreateExecutionRequest;
import org.mule.munit.remote.tools.client.BAT.model.request.ExecutionStatusRequest;
import org.mule.munit.remote.tools.client.BAT.model.request.TestType;
import org.mule.munit.remote.tools.client.BAT.model.response.CreateExecutionResponse;
import org.mule.munit.remote.tools.client.BAT.model.response.ExecutionResponse;
import org.mule.munit.remote.tools.client.BAT.model.response.ExecutionResultResponse;
import org.mule.munit.remote.tools.client.BAT.model.response.ExecutionStatus;
import org.mule.tools.client.core.AbstractClient;

public abstract class BATClientBase
extends AbstractClient {
    public static final String EXECUTION_BASE_URL = "/apitesting/xapi/v1/organizations/%s";
    public static final String EXECUTION_RESULT_BASE_URL = "/apitesting/worker/api/v1/organizations/%s/executions";
    public static final String RESULTS_PATH = "%s/results";
    public static final String EXECUTION_RESULT_PATH = "/executions/%s/result";
    public static final String EXECUTIONS_PATH = "/executions";
    public static final String EXECUTION_ID_PATH = "/executions/%s";
    public static final String BEARER_TOKEN = "Bearer";
    protected String bearerToken;
    private String organizationId;
    private String baseExecutionUrl;
    private String baseResultURL;
    private final String baseUri;

    public BATClientBase(String baseUri) {
        this.baseUri = baseUri;
    }

    protected void init() {
    }

    public CreateExecutionResponse createExecution(TestType testType) {
        this.setUp();
        CreateExecutionRequest request = new CreateExecutionRequest();
        request.setTestType(testType.name());
        Response response = this.post(this.baseExecutionUrl, EXECUTIONS_PATH, new Gson().toJson((Object)request));
        this.checkResponseStatus(response);
        return (CreateExecutionResponse)response.readEntity(CreateExecutionResponse.class);
    }

    public ExecutionResponse getExecution(String executionId) {
        this.setUp();
        Response response = this.get(this.baseExecutionUrl, String.format(EXECUTION_ID_PATH, executionId));
        this.checkResponseStatus(response);
        return (ExecutionResponse)new Gson().fromJson((String)response.readEntity(String.class), ExecutionResponse.class);
    }

    public ExecutionResultResponse getExecutionResult(String executionId) {
        this.setUp();
        Response response = this.get(this.baseExecutionUrl, String.format(EXECUTION_RESULT_PATH, executionId));
        this.checkResponseStatus(response);
        return (ExecutionResultResponse)new Gson().fromJson((String)response.readEntity(String.class), ExecutionResultResponse.class);
    }

    public void saveExecutionResult(String executionId, File file) throws IOException {
        this.setUp();
        String fileContent = new String(Files.readAllBytes(file.toPath()), StandardCharsets.UTF_8);
        FileDataBodyPart filePart = new FileDataBodyPart("result", file);
        FormDataBodyPart appInfoJsonPart = new FormDataBodyPart("appInfoJson", fileContent);
        MultiPart multipart = new FormDataMultiPart().bodyPart((BodyPart)filePart).bodyPart((BodyPart)appInfoJsonPart);
        Entity entity = Entity.entity((Object)multipart, (MediaType)multipart.getMediaType());
        Response response = this.put(this.baseResultURL, String.format(RESULTS_PATH, executionId), entity);
        this.checkResponseStatus(response);
    }

    public ExecutionResponse setExecutionStatus(String executionId, ExecutionStatus status) {
        this.setUp();
        ExecutionStatusRequest request = new ExecutionStatusRequest();
        request.setStatus(status.name());
        Response response = this.put(this.baseResultURL, String.format("%s", executionId), request);
        this.checkResponseStatus(response);
        return (ExecutionResponse)new Gson().fromJson((String)response.readEntity(String.class), ExecutionResponse.class);
    }

    protected void configureRequest(Invocation.Builder builder) {
        super.configureRequest(builder);
        builder.header("Authorization", (Object)String.format("%s %s", BEARER_TOKEN, this.bearerToken));
    }

    private void setUp() {
        if (!StringUtils.isEmpty((CharSequence)this.organizationId)) {
            return;
        }
        this.bearerToken = this.getBearerToken();
        this.organizationId = this.getOrganizationId();
        this.baseExecutionUrl = String.format(this.baseUri.concat(EXECUTION_BASE_URL), this.organizationId);
        this.baseResultURL = String.format(this.baseUri.concat(EXECUTION_RESULT_BASE_URL), this.organizationId);
    }

    protected abstract String getBearerToken();

    protected abstract String getOrganizationId();

    public abstract void renewToken();

    public String getBaseUri() {
        return this.baseUri;
    }
}

